/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.granite.client.tide.Context;
import org.granite.client.tide.InstanceStore;
import org.granite.client.tide.InstanceStoreFactory;
import org.granite.client.tide.impl.InstanceFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringInstanceStoreFactory
implements InstanceStoreFactory {
    private final ApplicationContext applicationContext;

    public SpringInstanceStoreFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public InstanceStore createStore(Context context, InstanceFactory instanceFactory) {
        return new SpringInstanceStore(context, this.applicationContext);
    }

    public static class SpringInstanceStore
    implements InstanceStore {
        private final Context context;
        private final ApplicationContext applicationContext;

        public SpringInstanceStore(Context context, ApplicationContext applicationContext) {
            this.context = context;
            this.applicationContext = applicationContext;
        }

        @Override
        public void init() {
        }

        @Override
        public <T> T set(String name, T instance) {
            return instance;
        }

        @Override
        public <T> T set(T instance) {
            return instance;
        }

        @Override
        public void remove(String name) {
        }

        @Override
        public void remove(Object instance) {
        }

        @Override
        public boolean exists(String name) {
            if (this.isInactive()) {
                return false;
            }
            return this.applicationContext.containsBean(name);
        }

        @Override
        public void inject(Object instance, String name, Map<String, Object> properties) {
        }

        @Override
        public void clear() {
        }

        @Override
        public List<String> allNames() {
            if (this.isInactive()) {
                return new ArrayList<String>();
            }
            return Arrays.asList(this.applicationContext.getBeanDefinitionNames());
        }

        @Override
        public <T> T getNoProxy(String name, Context context) {
            if (this.isInactive()) {
                return null;
            }
            return (T)this.applicationContext.getBean(name);
        }

        @Override
        public <T> T byName(String name, Context context) {
            try {
                if (this.isInactive()) {
                    return null;
                }
                return (T)this.applicationContext.getBean(name);
            }
            catch (NoSuchBeanDefinitionException e) {
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public <T> T byType(Class<T> type, Context context) {
            try {
                if (this.isInactive()) {
                    return null;
                }
                return (T)this.applicationContext.getBean(type);
            }
            catch (NoSuchBeanDefinitionException e) {
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public <T> T[] allByType(Class<T> type, Context context, boolean create) {
            try {
                if (this.isInactive()) {
                    return (Object[])Array.newInstance(type, 0);
                }
                Map instancesMap = this.applicationContext.getBeansOfType(type, true, create);
                Object[] all = (Object[])Array.newInstance(type, instancesMap.size());
                return instancesMap.values().toArray(all);
            }
            catch (IllegalStateException e) {
                return null;
            }
        }

        @Override
        public Map<String, Object> allByAnnotatedWith(Class<? extends Annotation> annotationClass, Context context) {
            try {
                if (this.isInactive()) {
                    return new HashMap<String, Object>();
                }
                return this.applicationContext.getBeansWithAnnotation(annotationClass);
            }
            catch (IllegalStateException illegalStateException) {
                return Collections.emptyMap();
            }
        }

        private boolean isInactive() {
            return this.applicationContext instanceof ConfigurableApplicationContext && !((ConfigurableApplicationContext)this.applicationContext).isActive();
        }
    }
}

