/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.validation;

import java.util.HashSet;
import org.granite.client.messaging.messages.responses.FaultMessage;
import org.granite.client.tide.Context;
import org.granite.client.tide.server.ExceptionHandler;
import org.granite.client.tide.server.TideFaultEvent;
import org.granite.client.validation.InvalidValue;
import org.granite.client.validation.NotifyingValidatorFactory;
import org.granite.client.validation.ServerConstraintViolation;

public class ValidationExceptionHandler
implements ExceptionHandler {
    @Override
    public boolean accepts(FaultMessage emsg) {
        return emsg.getCode().equals((Object)FaultMessage.Code.VALIDATION_FAILED);
    }

    @Override
    public void handle(Context context, FaultMessage emsg, TideFaultEvent faultEvent) {
        Object[] invalidValues;
        Object[] objectArray = invalidValues = emsg.getExtended() != null ? (Object[])emsg.getExtended().get("invalidValues") : null;
        if (invalidValues != null) {
            HashSet constraintViolations = new HashSet();
            for (Object v : invalidValues) {
                InvalidValue iv = (InvalidValue)v;
                Object rootBean = context.getEntityManager().getCachedObject(iv.getRootBean(), true);
                Object leafBean = null;
                if (iv.getBean() != null && (leafBean = context.getEntityManager().getCachedObject(iv.getBean(), true)) == null) {
                    Object bean = rootBean;
                    String[] path = iv.getPath().split("\\.");
                    for (int i = 0; i < path.length - 1; ++i) {
                        bean = context.getDataManager().getPropertyValue(bean, path[i]);
                    }
                    leafBean = bean;
                }
                ServerConstraintViolation violation = new ServerConstraintViolation(iv, rootBean, leafBean);
                constraintViolations.add(violation);
            }
            NotifyingValidatorFactory notifyingValidatorFactory = context.byType(NotifyingValidatorFactory.class);
            if (notifyingValidatorFactory == null) {
                throw new RuntimeException("No suitable validator factory defined, cannot process validation events");
            }
            notifyingValidatorFactory.getValidator().notifyConstraintViolations(null, constraintViolations);
        }
    }
}

