/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import org.granite.client.validation.NotifyingValidator;
import org.granite.client.validation.ValidationNotifier;

public class DefaultNotifyingValidator
implements NotifyingValidator {
    private final Validator validator;
    private final ValidationNotifier validationNotifier;

    public DefaultNotifyingValidator(Validator validator, ValidationNotifier validationNotifier) {
        this.validator = validator;
        this.validationNotifier = validationNotifier;
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        Set constraintViolations = this.validator.validate(object, (Class[])groups);
        HashSet genericsAreAPainInTheAss = new HashSet(constraintViolations.size());
        genericsAreAPainInTheAss.addAll(constraintViolations);
        this.notifyConstraintViolations(object, genericsAreAPainInTheAss);
        return constraintViolations;
    }

    @Override
    public <T> void notifyConstraintViolations(T root, Set<ConstraintViolation<?>> constraintViolations) {
        HashMap violationsMap = new HashMap();
        for (ConstraintViolation<?> violation : constraintViolations) {
            Object rootBean = violation.getRootBean();
            Object leafBean = violation.getLeafBean();
            Object bean = leafBean != null ? leafBean : rootBean;
            HashSet violations = (HashSet)violationsMap.get(bean);
            if (violations == null) {
                violations = new HashSet();
                violationsMap.put(bean, violations);
            }
            violations.add(violation);
        }
        for (Object bean : violationsMap.keySet()) {
            if (bean == root) continue;
            this.validationNotifier.notifyConstraintViolations(bean, (Set)violationsMap.get(bean));
        }
        this.validationNotifier.notifyConstraintViolations(root, (Set)violationsMap.get(root));
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        return this.validator.validateProperty(object, propertyName, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        return this.validator.validateValue(beanType, propertyName, value, (Class[])groups);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> entityClass) {
        return this.validator.getConstraintsForClass(entityClass);
    }

    public <T> T unwrap(Class<T> entityClass) {
        return (T)this.validator.unwrap(entityClass);
    }

    @Override
    public <T> void addConstraintViolationsHandler(T entity, NotifyingValidator.ConstraintViolationsHandler<T> handler) {
        this.validationNotifier.addConstraintViolationsHandler(entity, handler);
    }

    @Override
    public <T> void removeConstraintViolationsHandler(T entity, NotifyingValidator.ConstraintViolationsHandler<T> handler) {
        this.validationNotifier.removeConstraintViolationsHandler(entity, handler);
    }
}

