/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.validation;

import java.lang.reflect.Array;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.granite.client.util.WeakIdentityHashMap;
import org.granite.client.validation.NotifyingValidator;

public class ValidationNotifier {
    private final WeakIdentityHashMap<Object, NotifyingValidator.ConstraintViolationsHandler<?>[]> handlersMap = new WeakIdentityHashMap();

    public <T> void notifyConstraintViolations(T entity, Set<ConstraintViolation<T>> constraintViolations) {
        NotifyingValidator.ConstraintViolationsHandler[] handlers = (NotifyingValidator.ConstraintViolationsHandler[])this.handlersMap.get(entity);
        if (handlers == null) {
            return;
        }
        for (NotifyingValidator.ConstraintViolationsHandler handler : handlers) {
            handler.handle(entity, constraintViolations);
        }
    }

    public <T> void addConstraintViolationsHandler(T entity, NotifyingValidator.ConstraintViolationsHandler<T> handler) {
        NotifyingValidator.ConstraintViolationsHandler[] handlers = (NotifyingValidator.ConstraintViolationsHandler[])this.handlersMap.get(entity);
        if (handlers == null) {
            handlers = (NotifyingValidator.ConstraintViolationsHandler[])Array.newInstance(NotifyingValidator.ConstraintViolationsHandler.class, 1);
            handlers[0] = handler;
        } else {
            NotifyingValidator.ConstraintViolationsHandler[] newHandlers = (NotifyingValidator.ConstraintViolationsHandler[])Array.newInstance(NotifyingValidator.ConstraintViolationsHandler.class, handlers.length + 1);
            System.arraycopy(handlers, 0, newHandlers, 0, handlers.length);
            newHandlers[handlers.length] = handler;
            handlers = newHandlers;
        }
        this.handlersMap.put(entity, (Object)handlers);
    }

    public <T> void removeConstraintViolationsHandler(T entity, NotifyingValidator.ConstraintViolationsHandler<T> handler) {
        NotifyingValidator.ConstraintViolationsHandler[] handlers = (NotifyingValidator.ConstraintViolationsHandler[])this.handlersMap.get(entity);
        if (handlers == null) {
            return;
        }
        if (handlers.length == 1 && handlers[0] == handler) {
            this.handlersMap.remove(entity);
            return;
        }
        int index = -1;
        for (int i = 0; i < handlers.length; ++i) {
            if (handlers[i] != handler) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return;
        }
        NotifyingValidator.ConstraintViolationsHandler[] newHandlers = (NotifyingValidator.ConstraintViolationsHandler[])Array.newInstance(NotifyingValidator.ConstraintViolationsHandler.class, handlers.length - 1);
        if (index > 0) {
            System.arraycopy(handlers, 0, newHandlers, 0, index);
        }
        if (index < handlers.length - 1) {
            System.arraycopy(handlers, index + 1, newHandlers, index, handlers.length - index - 1);
        }
        this.handlersMap.put(entity, (Object)newHandlers);
    }
}

