/*
 * Decompiled with CFR 0.152.
 */
package org.granite.binding.collection;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.granite.binding.collection.CollectionChangeEvent;
import org.granite.binding.collection.CollectionChangeListener;
import org.granite.binding.collection.CollectionChangeSupport;
import org.granite.binding.collection.ObservableMap;

public class ObservableMapWrapper<K, V>
implements ObservableMap<K, V> {
    protected CollectionChangeSupport ccs = new CollectionChangeSupport(this);
    private final Map<K, V> wrappedMap;

    public ObservableMapWrapper(Map<K, V> map) {
        this.wrappedMap = map;
    }

    public Map<K, V> getWrappedObservable() {
        return this.wrappedMap;
    }

    @Override
    public void addCollectionChangeListener(CollectionChangeListener listener) {
        this.ccs.addCollectionChangeListener(listener);
    }

    @Override
    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        this.ccs.removeCollectionChangeListener(listener);
    }

    @Override
    public V put(K key, V value) {
        V oldValue = this.wrappedMap.put(key, value);
        if (oldValue != null) {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REPLACE, key, new Object[]{new Object[]{key, value}});
        } else {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.ADD, key, new Object[]{new Object[]{key, value}});
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> me : map.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V oldValue = this.wrappedMap.remove(key);
        if (oldValue != null) {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REMOVE, key, new Object[]{new Object[]{key, oldValue}});
        }
        return oldValue;
    }

    @Override
    public void clear() {
        if (this.wrappedMap.size() == 0) {
            return;
        }
        Object[] elements = new Object[this.wrappedMap.size()];
        int i = 0;
        for (Map.Entry<K, V> me : this.wrappedMap.entrySet()) {
            elements[i++] = new Object[]{me.getKey(), me.getValue()};
        }
        this.wrappedMap.clear();
        this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.CLEAR, null, elements);
    }

    @Override
    public V get(Object key) {
        return this.wrappedMap.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrappedMap.containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        return this.wrappedMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.wrappedMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.wrappedMap.entrySet();
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }
}

