/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide;

import java.nio.charset.Charset;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Future;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.granite.client.javafx.tide.ObservableRole;
import org.granite.client.messaging.messages.responses.FaultMessage;
import org.granite.client.tide.Context;
import org.granite.client.tide.Identity;
import org.granite.client.tide.impl.ComponentImpl;
import org.granite.client.tide.server.ExceptionHandler;
import org.granite.client.tide.server.FaultException;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.SimpleTideResponder;
import org.granite.client.tide.server.TideFaultEvent;
import org.granite.client.tide.server.TideResponder;
import org.granite.client.tide.server.TideResultEvent;

public abstract class BaseIdentity
extends ComponentImpl
implements Identity,
ExceptionHandler {
    private ReadOnlyBooleanWrapper loggedIn = new ReadOnlyBooleanWrapper((Object)this, "loggedIn");
    private StringProperty username = new ReadOnlyStringWrapper((Object)this, "username", null);

    public BaseIdentity() {
    }

    public BaseIdentity(ServerSession serverSession) {
        super(serverSession);
        final ServerSession localServerSession = serverSession;
        this.loggedIn.set(false);
        this.loggedIn.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> property, Boolean oldValue, Boolean newValue) {
                if (Boolean.TRUE.equals(newValue)) {
                    BaseIdentity.this.initSecurityCache();
                    localServerSession.afterLogin();
                } else {
                    BaseIdentity.this.username.set(null);
                    BaseIdentity.this.clearSecurityCache();
                }
            }
        });
    }

    public ReadOnlyBooleanProperty loggedInProperty() {
        return this.loggedIn.getReadOnlyProperty();
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn.get();
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn.set(loggedIn);
    }

    public StringProperty usernameProperty() {
        return this.username;
    }

    @Override
    public String getUsername() {
        return (String)this.username.get();
    }

    @Override
    public Future<String> checkLoggedIn(final TideResponder<String> tideResponder) {
        return super.call("isLoggedIn", new SimpleTideResponder<String>(){

            @Override
            public void result(TideResultEvent<String> event) {
                if (event.getResult() != null) {
                    BaseIdentity.this.username.set((Object)event.getResult());
                    BaseIdentity.this.loggedIn.set(true);
                } else if (BaseIdentity.this.isLoggedIn()) {
                    BaseIdentity.this.loggedIn.set(false);
                    BaseIdentity.this.getServerSession().sessionExpired();
                }
                if (tideResponder != null) {
                    tideResponder.result(event);
                }
            }

            @Override
            public void fault(TideFaultEvent event) {
                if (event.getFault().getCode() == FaultMessage.Code.ACCESS_DENIED) {
                    BaseIdentity.this.loggedIn.set(false);
                    BaseIdentity.this.getServerSession().logout(null);
                }
                if (tideResponder != null) {
                    tideResponder.fault(event);
                }
            }
        });
    }

    @Override
    public Future<String> login(String username, String password, TideResponder<String> tideResponder) {
        this.getServerSession().login(username, password);
        this.clearSecurityCache();
        Future<String> loggedIn = null;
        try {
            loggedIn = this.checkLoggedIn(tideResponder);
            loggedIn.get();
        }
        catch (FaultException e) {
        }
        catch (Exception e) {
            throw new RuntimeException("Could not login", e);
        }
        return loggedIn;
    }

    public Future<String> login(String username, String password, Charset charset, TideResponder<String> tideResponder) {
        this.getServerSession().login(username, password, charset);
        this.clearSecurityCache();
        Future<String> loggedIn = null;
        try {
            loggedIn = this.checkLoggedIn(tideResponder);
            loggedIn.get();
        }
        catch (FaultException e) {
        }
        catch (Exception e) {
            throw new RuntimeException("Could not login", e);
        }
        return loggedIn;
    }

    @Override
    public void logout() {
        this.logout(null);
    }

    @Override
    public void logout(final TideResponder<Void> tideResponder) {
        Observer observer = new Observer(){

            @Override
            public void update(Observable logout, Object event) {
                BaseIdentity.this.loggedIn.set(false);
                if (tideResponder != null) {
                    if (event instanceof TideResultEvent) {
                        tideResponder.result((TideResultEvent)event);
                    } else if (event instanceof TideFaultEvent) {
                        tideResponder.fault((TideFaultEvent)event);
                    }
                }
            }
        };
        this.getServerSession().logout(observer);
    }

    public abstract ObservableRole hasRole(String var1);

    protected abstract void initSecurityCache();

    public abstract void clearSecurityCache();

    @Override
    public boolean accepts(FaultMessage emsg) {
        return emsg.getCode() == FaultMessage.Code.NOT_LOGGED_IN;
    }

    @Override
    public void handle(Context context, FaultMessage emsg, TideFaultEvent faultEvent) {
        if (this.isLoggedIn()) {
            this.setLoggedIn(false);
            this.getServerSession().sessionExpired();
        }
    }
}

