/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide;

import java.util.Map;
import javafx.application.Platform;
import javafx.stage.Stage;
import javax.validation.TraversableResolver;
import javax.validation.ValidatorFactory;
import org.granite.client.javafx.tide.JavaFXDataManager;
import org.granite.client.javafx.tide.JavaFXServerSessionStatus;
import org.granite.client.javafx.tide.JavaFXTraversableResolver;
import org.granite.client.tide.Application;
import org.granite.client.tide.Context;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.validation.NotifyingValidation;
import org.granite.logging.Logger;

public class JavaFXApplication
implements Application {
    private static final Logger log = Logger.getLogger(JavaFXApplication.class);
    private final javafx.application.Application application;
    private final Stage stage;

    public JavaFXApplication() {
        this.application = null;
        this.stage = null;
    }

    public JavaFXApplication(javafx.application.Application application, Stage stage) {
        this.application = application;
        this.stage = stage;
    }

    @Override
    public void initContext(Context context, Map<String, Object> initialBeans) {
        JavaFXDataManager dataManager = new JavaFXDataManager();
        context.setDataManager(dataManager);
        if (this.application != null) {
            initialBeans.put(javafx.application.Application.class.getName(), this.application);
        }
        if (this.stage != null) {
            initialBeans.put(Stage.class.getName(), this.stage);
        }
        try {
            new BeanValidationConfiguration().configure(context, initialBeans);
        }
        catch (Throwable e) {
            log.info("Bean validation not available, support not configured", new Object[0]);
        }
    }

    @Override
    public void configure(Object instance) {
        if (instance instanceof ServerSession) {
            ((ServerSession)instance).setStatus(new JavaFXServerSessionStatus(this.stage));
        }
    }

    @Override
    public void execute(Object platformContext, Runnable runnable) {
        Platform.runLater((Runnable)runnable);
    }

    private static final class BeanValidationConfiguration {
        private BeanValidationConfiguration() {
        }

        public void configure(Context context, Map<String, Object> initialBeans) {
            JavaFXTraversableResolver traversableResolver = new JavaFXTraversableResolver(context.getDataManager());
            ValidatorFactory validatorFactory = NotifyingValidation.byDefaultProvider().configure().traversableResolver((TraversableResolver)traversableResolver).buildValidatorFactory();
            initialBeans.put(TraversableResolver.class.getName(), traversableResolver);
            initialBeans.put(ValidatorFactory.class.getName(), validatorFactory);
        }
    }
}

