/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import org.granite.client.javafx.persistence.collection.FXPersistentCollections;
import org.granite.client.javafx.persistence.collection.ObservablePersistentBag;
import org.granite.client.javafx.persistence.collection.ObservablePersistentList;
import org.granite.client.javafx.persistence.collection.ObservablePersistentMap;
import org.granite.client.javafx.persistence.collection.ObservablePersistentSet;
import org.granite.client.javafx.persistence.collection.ObservablePersistentSortedMap;
import org.granite.client.javafx.persistence.collection.ObservablePersistentSortedSet;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.PersistenceManager;
import org.granite.client.tide.data.impl.AbstractDataManager;
import org.granite.client.tide.data.spi.DataManager;
import org.granite.client.util.WeakIdentityHashMap;
import org.granite.logging.Logger;
import org.granite.util.TypeUtil;

public class JavaFXDataManager
extends AbstractDataManager {
    private static final Logger log = Logger.getLogger(JavaFXDataManager.class);
    private DataManager.TrackingHandler trackingHandler;
    public BooleanProperty dirty = new ReadOnlyBooleanWrapper((Object)this, "dirty", false);
    private Map<Object, ObservableDirtyEntity> dirtyEntityCache = new WeakIdentityHashMap();
    private Map<Object, ObservableDeepDirtyEntity> deepDirtyEntityCache = new WeakIdentityHashMap();
    private ListChangeListener<Object> listChangeListener = new DefaultListChangeListener<Object>();
    private SetChangeListener<Object> setChangeListener = new DefaultSetChangeListener<Object>();
    private MapChangeListener<Object, Object> mapChangeListener = new DefaultMapChangeListener<Object, Object>();
    private ChangeListener<Object> entityPropertyChangeListener = new EntityPropertyChangeListener<Object>();
    private ListChangeListener<Object> entityListChangeListener = new EntityListChangeListener<Object>();
    private SetChangeListener<Object> entitySetChangeListener = new EntitySetChangeListener<Object>();
    private MapChangeListener<Object, Object> entityMapChangeListener = new EntityMapChangeListener<Object, Object>();
    private WeakIdentityHashMap<Object, DataManager.TrackingType> trackingListeners = new WeakIdentityHashMap();

    @Override
    public void setTrackingHandler(DataManager.TrackingHandler trackingHandler) {
        this.trackingHandler = trackingHandler;
    }

    @Override
    public <T> T newInstance(Object source, Class<T> cast) throws IllegalAccessException, InstantiationException {
        if (ObservablePersistentList.class.isInstance(source)) {
            return (T)FXPersistentCollections.observablePersistentList();
        }
        if (ObservablePersistentBag.class.isInstance(source)) {
            return (T)FXPersistentCollections.observablePersistentBag();
        }
        if (ObservablePersistentSortedSet.class.isInstance(source)) {
            return (T)FXPersistentCollections.observablePersistentSortedSet();
        }
        if (ObservablePersistentSet.class.isInstance(source)) {
            return (T)FXPersistentCollections.observablePersistentSet();
        }
        if (ObservablePersistentSortedMap.class.isInstance(source)) {
            return (T)FXPersistentCollections.observablePersistentSortedMap();
        }
        if (ObservablePersistentMap.class.isInstance(source)) {
            return (T)FXPersistentCollections.observablePersistentMap();
        }
        return (T)TypeUtil.newInstance(source.getClass(), cast);
    }

    public ReadOnlyBooleanProperty dirtyProperty() {
        return this.dirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty.get();
    }

    public ObservableDirtyEntity dirtyEntity(Object entity) {
        ObservableDirtyEntity dirtyEntity = this.dirtyEntityCache.get(entity);
        if (dirtyEntity == null) {
            dirtyEntity = new ObservableDirtyEntity(entity);
            this.dirtyEntityCache.put(entity, dirtyEntity);
        }
        return dirtyEntity;
    }

    public ObservableDeepDirtyEntity deepDirtyEntity(Object entity) {
        ObservableDeepDirtyEntity deepDirtyEntity = this.deepDirtyEntityCache.get(entity);
        if (deepDirtyEntity == null) {
            deepDirtyEntity = new ObservableDeepDirtyEntity(entity);
            this.deepDirtyEntityCache.put(entity, deepDirtyEntity);
        }
        return deepDirtyEntity;
    }

    @Override
    public void startTracking(Object previous, Object parent) {
        if (previous == null || this.trackingListeners.containsKey(previous)) {
            return;
        }
        if (previous instanceof ObservableList) {
            if (parent != null) {
                ((ObservableList)previous).addListener(this.entityListChangeListener);
                this.trackingListeners.put(previous, (Object)DataManager.TrackingType.ENTITY_LIST);
            } else {
                ((ObservableList)previous).addListener(this.listChangeListener);
                this.trackingListeners.put(previous, (Object)DataManager.TrackingType.LIST);
            }
        } else if (previous instanceof ObservableSet) {
            if (parent != null) {
                ((ObservableSet)previous).addListener(this.entitySetChangeListener);
                this.trackingListeners.put(previous, (Object)DataManager.TrackingType.ENTITY_SET);
            } else {
                ((ObservableSet)previous).addListener(this.setChangeListener);
                this.trackingListeners.put(previous, (Object)DataManager.TrackingType.SET);
            }
        } else if (previous instanceof ObservableMap) {
            if (parent != null) {
                ((ObservableMap)previous).addListener(this.entityMapChangeListener);
                this.trackingListeners.put(previous, (Object)DataManager.TrackingType.ENTITY_MAP);
            } else {
                ((ObservableMap)previous).addListener(this.mapChangeListener);
                this.trackingListeners.put(previous, (Object)DataManager.TrackingType.MAP);
            }
        } else if (parent != null || this.isEntity(previous)) {
            List<ObservableValue<?>> properties = this.instrospectProperties(previous);
            for (ObservableValue<?> property : properties) {
                if (!(property instanceof WritableValue)) continue;
                property.addListener(this.entityPropertyChangeListener);
            }
            this.trackingListeners.put(previous, (Object)DataManager.TrackingType.ENTITY_PROPERTY);
        }
    }

    @Override
    public void stopTracking(Object previous, Object parent) {
        if (previous == null || !this.trackingListeners.containsKey(previous)) {
            return;
        }
        if (previous instanceof ObservableList) {
            if (parent != null) {
                ((ObservableList)previous).removeListener(this.entityListChangeListener);
            } else {
                ((ObservableList)previous).removeListener(this.listChangeListener);
            }
        } else if (previous instanceof ObservableSet) {
            if (parent != null) {
                ((ObservableSet)previous).removeListener(this.entitySetChangeListener);
            } else {
                ((ObservableSet)previous).removeListener(this.setChangeListener);
            }
        } else if (previous instanceof ObservableMap) {
            if (parent != null) {
                ((ObservableMap)previous).removeListener(this.entityMapChangeListener);
            } else {
                ((ObservableMap)previous).removeListener(this.mapChangeListener);
            }
        } else if (parent != null || this.isEntity(previous)) {
            List<ObservableValue<?>> properties = this.instrospectProperties(previous);
            for (ObservableValue<?> property : properties) {
                if (!(property instanceof WritableValue)) continue;
                property.removeListener(this.entityPropertyChangeListener);
            }
        }
        this.trackingListeners.remove(previous);
    }

    @Override
    public void clear() {
        this.dirty.set(false);
        this.deepDirtyEntityCache.clear();
        block9: for (Object obj : this.trackingListeners.keySet()) {
            DataManager.TrackingType type = (DataManager.TrackingType)((Object)this.trackingListeners.get(obj));
            if (type == null) continue;
            switch (type) {
                case LIST: {
                    ((ObservableList)obj).removeListener(this.listChangeListener);
                    break;
                }
                case SET: {
                    ((ObservableSet)obj).removeListener(this.setChangeListener);
                    break;
                }
                case MAP: {
                    ((ObservableMap)obj).removeListener(this.mapChangeListener);
                    break;
                }
                case ENTITY_PROPERTY: {
                    for (ObservableValue<?> property : this.instrospectProperties(obj)) {
                        if (!(property instanceof WritableValue)) continue;
                        property.removeListener(this.entityPropertyChangeListener);
                    }
                    continue block9;
                }
                case ENTITY_LIST: {
                    ((ObservableList)obj).removeListener(this.entityListChangeListener);
                    break;
                }
                case ENTITY_SET: {
                    ((ObservableSet)obj).removeListener(this.entitySetChangeListener);
                    break;
                }
                case ENTITY_MAP: {
                    ((ObservableMap)obj).removeListener(this.entityMapChangeListener);
                }
            }
        }
    }

    private List<ObservableValue<?>> instrospectProperties(Object obj) {
        ArrayList properties = new ArrayList();
        for (Method m : obj.getClass().getMethods()) {
            if (m.getParameterTypes().length != 0 || !m.getName().endsWith("Property") || !ObservableValue.class.isAssignableFrom(m.getReturnType())) continue;
            try {
                ObservableValue property = (ObservableValue)m.invoke(obj, new Object[0]);
                properties.add(property);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get property " + m.getName() + " on " + obj, e);
            }
        }
        return properties;
    }

    @Override
    public void notifyDirtyChange(boolean oldDirty, boolean dirty) {
        this.dirty.set(dirty);
    }

    @Override
    public void notifyEntityDirtyChange(Object entity, boolean oldDirtyEntity, boolean newDirtyEntity) {
        ObservableDirtyEntity dirtyEntity = this.dirtyEntityCache.get(entity);
        if (dirtyEntity != null) {
            dirtyEntity.fireValueChangedEvent();
        }
        for (ObservableDeepDirtyEntity deepDirtyEntity : this.deepDirtyEntityCache.values()) {
            deepDirtyEntity.fireValueChangedEvent();
        }
    }

    public class DefaultMapChangeListener<K, V>
    implements MapChangeListener<K, V> {
        public void onChanged(MapChangeListener.Change<? extends K, ? extends V> change) {
            if (change.wasAdded() && change.wasRemoved()) {
                JavaFXDataManager.this.trackingHandler.mapChangeHandler(DataManager.ChangeKind.REPLACE, change.getMap(), 0, new Object[]{new Object[]{change.getKey(), change.getValueRemoved(), change.getValueAdded()}});
            } else if (change.wasRemoved()) {
                JavaFXDataManager.this.trackingHandler.mapChangeHandler(DataManager.ChangeKind.REMOVE, change.getMap(), 0, new Object[]{new Object[]{change.getKey(), change.getValueRemoved()}});
            } else if (change.wasAdded()) {
                JavaFXDataManager.this.trackingHandler.mapChangeHandler(DataManager.ChangeKind.ADD, change.getMap(), 0, new Object[]{new Object[]{change.getKey(), change.getValueAdded()}});
            }
        }
    }

    public class EntityMapChangeListener<K, V>
    implements MapChangeListener<K, V> {
        public void onChanged(MapChangeListener.Change<? extends K, ? extends V> change) {
            if (change.wasAdded() && change.wasRemoved()) {
                JavaFXDataManager.this.trackingHandler.entityMapChangeHandler(DataManager.ChangeKind.REPLACE, change.getMap(), 0, new Object[]{new Object[]{change.getKey(), change.getValueRemoved(), change.getValueAdded()}});
            } else if (change.wasRemoved()) {
                JavaFXDataManager.this.trackingHandler.entityMapChangeHandler(DataManager.ChangeKind.REMOVE, change.getMap(), 0, new Object[]{new Object[]{change.getKey(), change.getValueRemoved()}});
            } else if (change.wasAdded()) {
                JavaFXDataManager.this.trackingHandler.entityMapChangeHandler(DataManager.ChangeKind.ADD, change.getMap(), 0, new Object[]{new Object[]{change.getKey(), change.getValueAdded()}});
            }
        }
    }

    public class DefaultSetChangeListener<E>
    implements SetChangeListener<E> {
        public void onChanged(SetChangeListener.Change<? extends E> change) {
            if (change.wasRemoved()) {
                JavaFXDataManager.this.trackingHandler.collectionChangeHandler(DataManager.ChangeKind.REMOVE, change.getSet(), null, new Object[]{change.getElementRemoved()});
            }
            if (change.wasAdded()) {
                JavaFXDataManager.this.trackingHandler.collectionChangeHandler(DataManager.ChangeKind.ADD, change.getSet(), null, new Object[]{change.getElementAdded()});
            }
        }
    }

    public class DefaultListChangeListener<E>
    implements ListChangeListener<E> {
        public void onChanged(ListChangeListener.Change<? extends E> change) {
            while (change.next()) {
                if (change.wasReplaced()) {
                    Object[] replaced = new Object[change.getAddedSize()];
                    for (int i = 0; i < change.getAddedSize(); ++i) {
                        replaced[i] = new Object[]{change.getRemoved().get(i), change.getAddedSubList().get(i)};
                    }
                    JavaFXDataManager.this.trackingHandler.entityCollectionChangeHandler(DataManager.ChangeKind.REPLACE, change.getList(), change.getFrom(), replaced);
                    return;
                }
                if (change.wasRemoved()) {
                    JavaFXDataManager.this.trackingHandler.collectionChangeHandler(DataManager.ChangeKind.REMOVE, change.getList(), change.getFrom(), change.getRemoved().toArray());
                }
                if (!change.wasAdded()) continue;
                JavaFXDataManager.this.trackingHandler.collectionChangeHandler(DataManager.ChangeKind.ADD, change.getList(), change.getFrom(), change.getAddedSubList().toArray());
            }
        }
    }

    public class EntitySetChangeListener<E>
    implements SetChangeListener<E> {
        public void onChanged(SetChangeListener.Change<? extends E> change) {
            if (change.wasRemoved()) {
                JavaFXDataManager.this.trackingHandler.entityCollectionChangeHandler(DataManager.ChangeKind.REMOVE, change.getSet(), null, new Object[]{change.getElementRemoved()});
            }
            if (change.wasAdded()) {
                JavaFXDataManager.this.trackingHandler.entityCollectionChangeHandler(DataManager.ChangeKind.ADD, change.getSet(), null, new Object[]{change.getElementAdded()});
            }
        }
    }

    public class EntityListChangeListener<E>
    implements ListChangeListener<E> {
        public void onChanged(ListChangeListener.Change<? extends E> change) {
            while (change.next()) {
                if (change.wasReplaced()) {
                    Object[] replaced = new Object[change.getAddedSize()];
                    for (int i = 0; i < change.getAddedSize(); ++i) {
                        replaced[i] = new Object[]{change.getRemoved().get(i), change.getAddedSubList().get(i)};
                    }
                    JavaFXDataManager.this.trackingHandler.entityCollectionChangeHandler(DataManager.ChangeKind.REPLACE, change.getList(), change.getFrom(), replaced);
                    return;
                }
                if (change.wasRemoved()) {
                    JavaFXDataManager.this.trackingHandler.entityCollectionChangeHandler(DataManager.ChangeKind.REMOVE, change.getList(), change.getFrom(), change.getRemoved().toArray());
                }
                if (!change.wasAdded()) continue;
                JavaFXDataManager.this.trackingHandler.entityCollectionChangeHandler(DataManager.ChangeKind.ADD, change.getList(), change.getFrom(), change.getAddedSubList().toArray());
            }
        }
    }

    public class EntityPropertyChangeListener<E>
    implements ChangeListener<E> {
        public void changed(ObservableValue<? extends E> property, E oldValue, E newValue) {
            if (property instanceof ReadOnlyProperty) {
                if (((ReadOnlyProperty)property).getBean() == null) {
                    throw new IllegalStateException("Property bean must be defined");
                }
                if (((ReadOnlyProperty)property).getName() == null || ((ReadOnlyProperty)property).getName().trim().length() == 0) {
                    throw new IllegalStateException("Property name must be defined");
                }
                JavaFXDataManager.this.trackingHandler.entityPropertyChangeHandler(((ReadOnlyProperty)property).getBean(), ((ReadOnlyProperty)property).getName(), oldValue, newValue);
            }
        }
    }

    private class ObservableDeepDirtyEntity
    extends ReadOnlyBooleanPropertyBase {
        private Object entity;
        private EntityManager entityManager;
        private ChangeListener<Object> changeListener = new WeakChangeListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<?> observable, Object oldValue, Object newValue) {
                ObservableDeepDirtyEntity.this.entity = newValue;
                ObservableDeepDirtyEntity.this.entityManager = PersistenceManager.getEntityManager(newValue);
                ObservableDeepDirtyEntity.this.fireValueChangedEvent();
            }
        });

        public ObservableDeepDirtyEntity(Object entity) {
            if (entity instanceof ObservableValue) {
                ObservableValue value = (ObservableValue)entity;
                this.entity = value.getValue();
                value.addListener(this.changeListener);
            } else {
                this.entity = entity;
            }
            this.entityManager = PersistenceManager.getEntityManager(this.entity);
        }

        public Object getBean() {
            return JavaFXDataManager.this;
        }

        public String getName() {
            return "deepDirtyEntity";
        }

        public boolean get() {
            if (this.entity == null) {
                return false;
            }
            if (this.entityManager == null) {
                this.entityManager = PersistenceManager.getEntityManager(this.entity);
                if (this.entityManager == null) {
                    return false;
                }
            }
            return this.entityManager.isDeepDirtyEntity(this.entity);
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }

    private class ObservableDirtyEntity
    extends ReadOnlyBooleanPropertyBase {
        private Object entity;
        private EntityManager entityManager;
        private ChangeListener<Object> changeListener = new WeakChangeListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<?> observable, Object oldValue, Object newValue) {
                ObservableDirtyEntity.this.entity = newValue;
                ObservableDirtyEntity.this.entityManager = PersistenceManager.getEntityManager(newValue);
                ObservableDirtyEntity.this.fireValueChangedEvent();
            }
        });

        public ObservableDirtyEntity(Object entity) {
            if (entity instanceof ObservableValue) {
                ObservableValue value = (ObservableValue)entity;
                this.entity = value.getValue();
                value.addListener(this.changeListener);
            } else {
                this.entity = entity;
            }
            this.entityManager = PersistenceManager.getEntityManager(this.entity);
        }

        public Object getBean() {
            return JavaFXDataManager.this;
        }

        public String getName() {
            return "deepDirtyEntity";
        }

        public boolean get() {
            if (this.entity == null) {
                return false;
            }
            if (this.entityManager == null) {
                this.entityManager = PersistenceManager.getEntityManager(this.entity);
                if (this.entityManager == null) {
                    return false;
                }
            }
            return this.entityManager.isDirtyEntity(this.entity);
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }
}

