/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.stage.Stage;
import org.granite.client.tide.server.ServerSession;

public class JavaFXServerSessionStatus
implements ServerSession.Status {
    private Stage stage;
    private BooleanProperty busy = new ReadOnlyBooleanWrapper((Object)this, "busy", false);
    private BooleanProperty connected = new ReadOnlyBooleanWrapper((Object)this, "connected", false);
    private BooleanProperty showBusyCursor = new SimpleBooleanProperty((Object)this, "showBusyCursor", true);

    public JavaFXServerSessionStatus() {
        this(null);
    }

    public JavaFXServerSessionStatus(Stage stage) {
        this.stage = stage;
        this.busy.addListener((ChangeListener)new ChangeListener<Boolean>(){
            private Cursor saveCursor = Cursor.DEFAULT;

            public void changed(ObservableValue<? extends Boolean> property, Boolean oldValue, Boolean newValue) {
                if (JavaFXServerSessionStatus.this.stage != null && JavaFXServerSessionStatus.this.stage.getScene() != null && JavaFXServerSessionStatus.this.showBusyCursor.get()) {
                    if (Boolean.FALSE.equals(oldValue)) {
                        this.saveCursor = JavaFXServerSessionStatus.this.stage.getScene().getCursor();
                        JavaFXServerSessionStatus.this.stage.getScene().setCursor(Cursor.WAIT);
                    } else {
                        JavaFXServerSessionStatus.this.stage.getScene().setCursor(this.saveCursor);
                    }
                }
            }
        });
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public ReadOnlyBooleanProperty busyProperty() {
        return this.busy;
    }

    public ReadOnlyBooleanProperty connectedProperty() {
        return this.connected;
    }

    public BooleanProperty showBusyCursorProperty() {
        return this.showBusyCursor;
    }

    @Override
    public boolean isBusy() {
        return this.busy.get();
    }

    @Override
    public void setBusy(boolean busy) {
        this.busy.set(busy);
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public void setConnected(boolean connected) {
        this.connected.set(connected);
    }

    @Override
    public boolean isShowBusyCursor() {
        return this.showBusyCursor.get();
    }

    @Override
    public void setShowBusyCursor(boolean showBusyCursor) {
        this.showBusyCursor.set(showBusyCursor);
    }
}

