/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide;

import java.lang.reflect.Method;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javax.inject.Inject;
import javax.inject.Named;
import org.granite.client.javafx.tide.JavaFXDataManager;
import org.granite.client.javafx.util.ChainedObservableValue;
import org.granite.client.javafx.util.ChainedProperty;
import org.granite.client.javafx.util.ChangeWatcher;
import org.granite.client.tide.Context;
import org.granite.client.tide.ContextAware;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.PersistenceManager;

@Named
public class ManagedEntity<T>
implements ContextAware {
    private ObjectProperty<T> instance = new SimpleObjectProperty((Object)this, "instance");
    private ChangeWatcher<T> instanceWatcher = ChangeWatcher.watch(this.instance);
    @Inject
    private EntityManager entityManager;
    private JavaFXDataManager dataManager;
    private ReadOnlyBooleanWrapper saved = new ReadOnlyBooleanWrapper((Object)this, "saved", true);
    private ReadOnlyBooleanWrapper dirty = new ReadOnlyBooleanWrapper((Object)this, "dirty", false);
    private ChangeWatcher.Trigger<T, Object> entityChangeTrigger = new ChangeWatcher.Trigger<T, Object>(){

        public Object beforeChange(T oldInstance) {
            if (oldInstance != null) {
                ManagedEntity.this.entityManager.resetEntity(oldInstance);
                ReadOnlyProperty versionProperty = ManagedEntity.this.getVersionProperty(oldInstance);
                versionProperty.removeListener(ManagedEntity.this.versionChangeListener);
                ManagedEntity.this.dirty.unbind();
            }
            return null;
        }

        public void afterChange(T newInstance, Object value) {
            if (newInstance == null) {
                return;
            }
            ReadOnlyProperty versionProperty = ManagedEntity.this.getVersionProperty(newInstance);
            versionProperty.addListener(ManagedEntity.this.versionChangeListener);
            ManagedEntity.this.saved.set(versionProperty.getValue() != null);
            EntityManager entityManager = PersistenceManager.getEntityManager(newInstance);
            if (entityManager == null) {
                ManagedEntity.this.entityManager.mergeExternalData(newInstance);
            } else if (entityManager != ManagedEntity.this.entityManager) {
                throw new RuntimeException("Entity " + newInstance + " cannot be attached: already attached to another entity manager");
            }
            ManagedEntity.this.dirty.bind((ObservableValue)ManagedEntity.this.dataManager.deepDirtyEntity(newInstance));
        }
    };
    private ChangeListener<Object> versionChangeListener = new ChangeListener<Object>(){

        public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
            ManagedEntity.this.saved.set(newValue != null);
        }
    };

    public ManagedEntity() {
    }

    public ManagedEntity(EntityManager entityManager) {
        this.init(entityManager);
    }

    public ManagedEntity(EntityManager entityManager, T value) {
        this.init(entityManager);
        this.instance.set(value);
    }

    public ObjectProperty<T> instanceProperty() {
        return this.instance;
    }

    public T getInstance() {
        return (T)this.instance.get();
    }

    public void setInstance(T value) {
        this.instance.set(value);
    }

    public <X> ChainedProperty<T, X> instanceProperty(ChainedProperty.PropertyGetter<T, X> getter) {
        return new ChainedProperty(this.instanceWatcher, getter);
    }

    public <X> ChainedObservableValue<T, X> instanceObservableValue(ChainedObservableValue.ObservableValueGetter<T, X> getter) {
        return new ChainedObservableValue(this.instanceWatcher, getter);
    }

    public ReadOnlyBooleanProperty savedProperty() {
        return this.saved.getReadOnlyProperty();
    }

    public boolean isSaved() {
        return this.saved.get();
    }

    public ReadOnlyBooleanProperty dirtyProperty() {
        return this.dirty.getReadOnlyProperty();
    }

    public boolean isDirty() {
        return this.dirty.get();
    }

    @Override
    public void setContext(Context context) {
        this.init(context.getEntityManager());
    }

    private void init(EntityManager entityManager) {
        if (this.entityManager == null) {
            this.entityManager = entityManager;
        }
        this.dataManager = (JavaFXDataManager)this.entityManager.getDataManager();
        this.instanceWatcher.addTrigger(this.entityChangeTrigger);
    }

    public void reset() {
        if (this.instance.get() == null) {
            return;
        }
        this.entityManager.resetEntity(this.instance.get());
    }

    private ReadOnlyProperty<Object> getVersionProperty(Object value) {
        String versionPropertyName = this.dataManager.getVersionPropertyName(value);
        if (versionPropertyName == null) {
            throw new RuntimeException("No version property found on entity " + value);
        }
        try {
            Method m = value.getClass().getMethod(versionPropertyName + "Property", new Class[0]);
            return (ReadOnlyProperty)m.invoke(value, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get version property on entity " + value, e);
        }
    }
}

