/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide;

import java.io.IOException;
import java.io.InputStream;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.util.Callback;
import javax.inject.Named;
import org.granite.client.tide.Context;
import org.granite.logging.Logger;

public abstract class ManagedView {
    private final String viewId;

    public ManagedView(String viewId) {
        this.viewId = viewId;
    }

    public String getViewId() {
        return this.viewId;
    }

    public int hashCode() {
        return this.viewId.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ManagedView && ((ManagedView)obj).getViewId().equals(this.viewId);
    }

    public abstract Parent load(Context var1);

    public static SimpleView of(String viewId, Parent root) {
        return new SimpleView(viewId, root);
    }

    public static FXMLView fxml(String url) {
        return new FXMLView(url);
    }

    public static FXMLView fxml(String url, Class<?> resourceRoot) {
        return new FXMLView(url, resourceRoot);
    }

    public static FXMLView fxml(Class<?> resourceRoot) {
        return new FXMLView(resourceRoot.getSimpleName() + ".fxml", resourceRoot);
    }

    public static class FXMLView
    extends ManagedView {
        private static final Logger log = Logger.getLogger(FXMLView.class);
        private final Class<?> resourceRoot;

        public FXMLView(String viewId) {
            super(viewId);
            this.resourceRoot = this.getClass();
        }

        public FXMLView(String viewId, Class<?> root) {
            super(viewId);
            this.resourceRoot = root;
        }

        @Override
        public Parent load(Context context) {
            InputStream fxmlStream = null;
            try {
                fxmlStream = this.resourceRoot.getResourceAsStream(this.getViewId());
                FXMLLoader loader = new FXMLLoader();
                loader.setLocation(this.resourceRoot.getResource(this.getViewId()));
                loader.setControllerFactory((Callback)new ControllerFactory(context));
                loader.getNamespace().putAll(context.allByAnnotatedWith(Named.class));
                Parent parent = (Parent)loader.load(fxmlStream);
                return parent;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load view " + this.getViewId(), e);
            }
            finally {
                if (fxmlStream != null) {
                    try {
                        fxmlStream.close();
                    }
                    catch (IOException e) {
                        log.warn((Throwable)e, "Could not close fxml stream", new Object[0]);
                    }
                }
            }
        }

        private class ControllerFactory
        implements Callback<Class<?>, Object> {
            private Context context;

            public ControllerFactory(Context context) {
                this.context = context;
            }

            public Object call(Class<?> type) {
                return this.context.byType(type);
            }
        }
    }

    public static class SimpleView
    extends ManagedView {
        private Parent root;

        public SimpleView(String viewId, Parent root) {
            super(viewId);
            this.root = root;
        }

        @Override
        public Parent load(Context context) {
            return this.root;
        }
    }
}

