/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide;

import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import org.granite.client.javafx.tide.BaseIdentity;
import org.granite.client.javafx.tide.spring.Identity;
import org.granite.client.tide.Context;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.SimpleTideResponder;
import org.granite.client.tide.server.TideFaultEvent;
import org.granite.client.tide.server.TideResponder;
import org.granite.client.tide.server.TideResultEvent;

public class ObservablePermission
extends ReadOnlyBooleanPropertyBase {
    private final BaseIdentity identity;
    private final Context context;
    private final ServerSession serverSession;
    private final String name;
    private final Object entity;
    private final String action;
    private Boolean hasPermission = null;

    public ObservablePermission(Identity identity, Context context, ServerSession serverSession, String name, Object entity, String action) {
        this.identity = identity;
        this.context = context;
        this.serverSession = serverSession;
        this.name = name;
        this.entity = entity;
        this.action = action;
    }

    public Object getBean() {
        return this.identity;
    }

    public String getName() {
        return this.name;
    }

    public boolean get() {
        if (this.hasPermission == null) {
            if (this.identity.isLoggedIn()) {
                this.getFromRemote(null);
            }
            return false;
        }
        return this.hasPermission;
    }

    public boolean get(TideResponder<Boolean> tideResponder) {
        if (this.hasPermission != null) {
            if (tideResponder != null) {
                TideResultEvent<Boolean> event = new TideResultEvent<Boolean>(this.context, this.serverSession, null, this.hasPermission);
                tideResponder.result(event);
            }
            return this.hasPermission;
        }
        if (this.identity.isLoggedIn()) {
            this.getFromRemote(tideResponder);
        }
        return false;
    }

    public void getFromRemote(final TideResponder<Boolean> tideResponder) {
        this.identity.call(this.name, this.entity, this.action, new SimpleTideResponder<Boolean>(){

            @Override
            public void result(TideResultEvent<Boolean> event) {
                if (tideResponder != null) {
                    tideResponder.result(event);
                }
                ObservablePermission.this.hasPermission = event.getResult();
                ObservablePermission.this.fireValueChangedEvent();
            }

            @Override
            public void fault(TideFaultEvent event) {
                if (tideResponder != null) {
                    tideResponder.fault(event);
                }
                ObservablePermission.this.clear();
            }
        });
    }

    public void clear() {
        this.hasPermission = null;
        this.fireValueChangedEvent();
    }
}

