/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide;

import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import org.granite.client.javafx.tide.BaseIdentity;
import org.granite.client.tide.Context;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.SimpleTideResponder;
import org.granite.client.tide.server.TideFaultEvent;
import org.granite.client.tide.server.TideResponder;
import org.granite.client.tide.server.TideResultEvent;

public class ObservableRole
extends ReadOnlyBooleanPropertyBase {
    private final BaseIdentity identity;
    private final Context context;
    private final ServerSession serverSession;
    private final String name;
    private final String roleName;
    private Boolean hasRole = null;

    public ObservableRole(BaseIdentity identity, Context context, ServerSession serverSession, String name, String roleName) {
        this.identity = identity;
        this.context = context;
        this.serverSession = serverSession;
        this.name = name;
        this.roleName = roleName;
    }

    public Object getBean() {
        return this.identity;
    }

    public String getName() {
        return this.name + "." + this.roleName;
    }

    public boolean get() {
        if (this.hasRole == null) {
            if (this.identity.isLoggedIn()) {
                this.getFromRemote(null);
            }
            return false;
        }
        return this.hasRole;
    }

    public boolean get(TideResponder<Boolean> tideResponder) {
        if (this.hasRole != null) {
            if (tideResponder != null) {
                TideResultEvent<Boolean> event = new TideResultEvent<Boolean>(this.context, this.serverSession, null, this.hasRole);
                tideResponder.result(event);
            }
            return this.hasRole;
        }
        if (this.identity.isLoggedIn()) {
            this.getFromRemote(tideResponder);
        }
        return false;
    }

    public void getFromRemote(final TideResponder<Boolean> tideResponder) {
        this.identity.call(this.name, this.roleName, new SimpleTideResponder<Boolean>(){

            @Override
            public void result(TideResultEvent<Boolean> event) {
                if (tideResponder != null) {
                    tideResponder.result(event);
                }
                ObservableRole.this.hasRole = event.getResult();
                ObservableRole.this.fireValueChangedEvent();
            }

            @Override
            public void fault(TideFaultEvent event) {
                if (tideResponder != null) {
                    tideResponder.fault(event);
                }
                ObservableRole.this.clear();
            }
        });
    }

    public void clear() {
        this.hasRole = null;
        this.fireValueChangedEvent();
    }
}

