/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide;

import java.io.IOException;
import java.io.InputStream;
import javafx.fxml.FXMLLoader;
import javafx.util.Callback;
import javax.inject.Named;
import org.granite.client.tide.Context;

public class TideFXMLLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object load(Context context, String url, Class<?> controllerClass) throws IOException {
        InputStream fxmlStream = null;
        try {
            fxmlStream = controllerClass.getResourceAsStream(url);
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(controllerClass.getResource(url));
            loader.setControllerFactory((Callback)new ControllerFactory(context));
            loader.getNamespace().putAll(context.allByAnnotatedWith(Named.class));
            Object object = loader.load(fxmlStream);
            return object;
        }
        finally {
            if (fxmlStream != null) {
                fxmlStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object load(String url, final Object controller) throws IOException {
        InputStream fxmlStream = null;
        try {
            fxmlStream = controller.getClass().getResourceAsStream(url);
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(controller.getClass().getResource(url));
            loader.setControllerFactory(new Callback<Class<?>, Object>(){

                public Object call(Class<?> type) {
                    if (type.isInstance(controller)) {
                        return controller;
                    }
                    try {
                        return type.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not instantiate controller of class " + type);
                    }
                }
            });
            Object object = loader.load(fxmlStream);
            return object;
        }
        finally {
            if (fxmlStream != null) {
                fxmlStream.close();
            }
        }
    }

    public static class ControllerFactory
    implements Callback<Class<?>, Object> {
        private final Context context;

        public ControllerFactory(Context context) {
            this.context = context;
        }

        public Object call(Class<?> type) {
            return this.context.byType(type);
        }
    }
}

