/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.granite.client.javafx.tide.ManagedView;
import org.granite.client.tide.Context;
import org.granite.client.tide.ContextAware;
import org.granite.client.tide.ViewScopeHolder;

public class ViewNavigator
implements ContextAware {
    private Context context;
    private Stage stage;
    private ObjectProperty<ManagedView> currentView = new SimpleObjectProperty((Object)this, "currentView");

    public ViewNavigator() {
        this.currentView.addListener((ChangeListener)new ChangeListener<ManagedView>(){

            public void changed(ObservableValue<? extends ManagedView> view, ManagedView oldView, ManagedView newView) {
                ViewNavigator.this.show(newView);
            }
        });
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
        this.stage = context.byType(Stage.class);
    }

    public Stage getStage() {
        return this.stage;
    }

    public Parent getRoot() {
        return this.stage.getScene().getRoot();
    }

    public ObjectProperty<ManagedView> currentViewProperty() {
        return this.currentView;
    }

    public ManagedView getCurrentView() {
        return (ManagedView)this.currentView.get();
    }

    public void setCurrentView(ManagedView view) {
        this.currentView.set((Object)view);
    }

    protected Parent show(ManagedView view) {
        ViewScopeHolder.get().ensureViewId(view.getViewId());
        this.preChangeView(view, this.stage);
        Parent root = view.load(this.context);
        Scene scene = this.prepareScene(view, this.stage, root);
        this.stage.setScene(scene);
        this.postChangeView(view, this.stage);
        return root;
    }

    protected void preChangeView(ManagedView view, Stage stage) {
    }

    protected void postChangeView(ManagedView view, Stage stage) {
        if (!stage.isShowing()) {
            stage.show();
        }
    }

    protected Scene prepareScene(ManagedView view, Stage stage, Parent root) {
        return new Scene(root);
    }
}

