/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide.cdi;

import java.lang.annotation.Annotation;
import java.util.Set;
import javafx.stage.Stage;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Inject;
import javax.validation.TraversableResolver;
import org.granite.client.javafx.tide.JavaFXApplication;
import org.granite.client.javafx.tide.JavaFXDataManager;
import org.granite.client.tide.Application;
import org.granite.client.tide.ApplicationConfigurable;
import org.granite.client.tide.Context;
import org.granite.client.tide.ContextAware;
import org.granite.client.tide.EventBus;
import org.granite.client.tide.NameAware;
import org.granite.client.tide.cdi.CDIContextManager;
import org.granite.client.tide.cdi.CDIEventBus;
import org.granite.client.tide.cdi.ViewContext;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.validation.NotifyingValidatorFactory;
import org.granite.logging.Logger;

public class JavaFXTideClientExtension
implements Extension {
    private static final Logger log = Logger.getLogger(JavaFXTideClientExtension.class);
    private Application application;

    public JavaFXTideClientExtension() {
        this.application = new JavaFXApplication(null, null);
    }

    public JavaFXTideClientExtension(javafx.application.Application application, Stage stage) {
        this.application = new JavaFXApplication(application, stage);
    }

    public JavaFXTideClientExtension(Application application) {
        this.application = application;
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        log.debug("Register internal Tide beans", new Object[0]);
        event.addAnnotatedType(beanManager.createAnnotatedType(JavaFXApplication.class));
        event.addAnnotatedType(beanManager.createAnnotatedType(CDIEventBus.class));
        event.addAnnotatedType(beanManager.createAnnotatedType(JavaFXCDIContextManager.class));
        try {
            event.addAnnotatedType(beanManager.createAnnotatedType(JavaFXValidation.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        log.debug("Register internal Tide scopes", new Object[0]);
        event.addContext((javax.enterprise.context.spi.Context)new ViewContext());
    }

    public void processProducer(@Observes ProcessProducer<Object, Object> event, BeanManager beanManager) {
        event.setProducer(new ProducerWrapper(this.application, beanManager, event.getProducer(), event.getAnnotatedMember()));
    }

    public void processInjectionTarget(@Observes ProcessInjectionTarget<Object> event, BeanManager beanManager) {
        event.setInjectionTarget(new InjectionTargetWrapper(this.application, beanManager, event.getInjectionTarget(), event.getAnnotatedType()));
    }

    public static class InjectionTargetWrapper<T>
    implements InjectionTarget<T> {
        private Application application;
        private BeanManager beanManager;
        private InjectionTarget<T> injectionTarget;
        private AnnotatedType<T> annotatedType;

        public InjectionTargetWrapper(Application application, BeanManager beanManager, InjectionTarget<T> injectionTarget, AnnotatedType<T> annotatedType) {
            this.application = application;
            this.beanManager = beanManager;
            this.injectionTarget = injectionTarget;
            this.annotatedType = annotatedType;
        }

        public void dispose(T instance) {
            this.injectionTarget.dispose(instance);
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionTarget.getInjectionPoints();
        }

        public void inject(T instance, CreationalContext<T> cc) {
            this.injectionTarget.inject(instance, cc);
        }

        public T produce(CreationalContext<T> cc) {
            return (T)this.injectionTarget.produce(cc);
        }

        public void postConstruct(T instance) {
            Set beans;
            if (instance instanceof NameAware && (beans = this.beanManager.getBeans(this.annotatedType.getBaseType(), new Annotation[0])).size() == 1) {
                ((NameAware)instance).setName(((Bean)beans.iterator().next()).getName());
            }
            if (instance instanceof ContextAware && (beans = this.beanManager.getBeans(Context.class, new Annotation[0])).size() == 1) {
                Bean bean = (Bean)beans.iterator().next();
                CreationalContext ccc = this.beanManager.createCreationalContext((Contextual)bean);
                ((ContextAware)instance).setContext((Context)this.beanManager.getReference(bean, Context.class, ccc));
            }
            if (instance != null && instance.getClass().isAnnotationPresent(ApplicationConfigurable.class)) {
                this.application.configure(instance);
            }
            this.injectionTarget.postConstruct(instance);
        }

        public void preDestroy(T instance) {
            this.injectionTarget.preDestroy(instance);
        }
    }

    public static class ProducerWrapper<T>
    implements Producer<T> {
        private Application application;
        private BeanManager beanManager;
        private Producer<T> producer;
        private AnnotatedMember<T> annotatedMember;

        public ProducerWrapper(Application application, BeanManager beanManager, Producer<T> producer, AnnotatedMember<T> annotatedMember) {
            this.application = application;
            this.beanManager = beanManager;
            this.producer = producer;
            this.annotatedMember = annotatedMember;
        }

        public void dispose(T instance) {
            this.producer.dispose(instance);
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.producer.getInjectionPoints();
        }

        public T produce(CreationalContext<T> cc) {
            Set beans;
            Object instance = this.producer.produce(cc);
            if (instance instanceof NameAware && (beans = this.beanManager.getBeans(this.annotatedMember.getBaseType(), new Annotation[0])).size() == 1) {
                ((NameAware)instance).setName(((Bean)beans.iterator().next()).getName());
            }
            if (instance instanceof ContextAware && (beans = this.beanManager.getBeans(Context.class, new Annotation[0])).size() == 1) {
                Bean bean = (Bean)beans.iterator().next();
                CreationalContext ccc = this.beanManager.createCreationalContext((Contextual)bean);
                ((ContextAware)instance).setContext((Context)this.beanManager.getReference(bean, Context.class, ccc));
            }
            if (instance != null && instance.getClass().isAnnotationPresent(ApplicationConfigurable.class)) {
                this.application.configure(instance);
            }
            return (T)instance;
        }
    }

    @ApplicationScoped
    public static class JavaFXValidation {
        private Context context;

        protected JavaFXValidation() {
        }

        @Inject
        public JavaFXValidation(Context context) {
            this.context = context;
        }

        @Produces
        public TraversableResolver getTraversableResolver() {
            return (TraversableResolver)this.context.getInitialBeans().get("traversableResolver");
        }

        @Produces
        public NotifyingValidatorFactory getValidatorFactory() {
            return (NotifyingValidatorFactory)this.context.getInitialBeans().get("validatorFactory");
        }
    }

    @ApplicationScoped
    public static class JavaFXCDIContextManager
    extends CDIContextManager {
        protected JavaFXCDIContextManager() {
        }

        @Inject
        public JavaFXCDIContextManager(Application application, EventBus eventBus) {
            super(application, eventBus);
        }

        @Override
        @Produces
        public Context getContext() {
            return this.getContext(null);
        }

        @Override
        @Produces
        public EntityManager getEntityManager() {
            return this.getContext(null).getEntityManager();
        }

        @Override
        @Produces
        public JavaFXDataManager getDataManager() {
            return (JavaFXDataManager)super.getDataManager();
        }
    }
}

