/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import org.granite.client.javafx.tide.collections.PageChangeListener;
import org.granite.client.javafx.util.ListListenerHelper;
import org.granite.client.javafx.util.ListenerHelper;
import org.granite.client.tide.collection.AbstractPagedCollection;
import org.granite.client.tide.collection.PageFilterFinder;
import org.granite.client.tide.collection.SimpleFilterFinder;
import org.granite.client.tide.server.Component;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.TideResultEvent;
import org.granite.client.tide.server.TideRpcEvent;

@Named
public class PagedQuery<E, F>
extends AbstractPagedCollection<E, F>
implements ObservableList<E> {
    private List<E> internalWrappedList = new ArrayList();
    protected ObservableList<E> wrappedList;
    private ListenerHelper<PageChangeListener<E, F>> pageChangeHelper = new ListenerHelper(PageChangeListener.class);
    private Map<String, Object> internalFilterMap;
    private ObservableMap<String, Object> filterMap;
    private ObjectProperty<F> filter;
    private ListListenerHelper<E> helper = new ListListenerHelper();
    private static final int[] EMPTY_PERMUTATION = new int[0];

    protected PagedQuery() {
    }

    public PagedQuery(ServerSession serverSession) {
        super(serverSession);
        this.initWrappedList();
    }

    public PagedQuery(Component remoteComponent, String methodName, int maxResults) {
        super(remoteComponent, methodName, maxResults);
        this.initWrappedList();
    }

    public PagedQuery(Component remoteComponent, PageFilterFinder<E> finder, int maxResults) {
        super(remoteComponent, finder, maxResults);
        this.initWrappedList();
    }

    public PagedQuery(Component remoteComponent, SimpleFilterFinder<E> finder, int maxResults) {
        super(remoteComponent, finder, maxResults);
        this.initWrappedList();
    }

    @Override
    protected List<E> getInternalWrappedList() {
        return this.internalWrappedList;
    }

    @Override
    protected List<E> getWrappedList() {
        return this.wrappedList;
    }

    private void initWrappedList() {
        this.wrappedList = FXCollections.observableList(this.internalWrappedList);
        this.wrappedList.addListener((ListChangeListener)new WrappedListListChangeListener());
    }

    @Override
    protected void initFilter() {
        this.internalFilterMap = new HashMap<String, Object>();
        this.filterMap = FXCollections.observableMap(Collections.synchronizedMap(this.internalFilterMap));
        this.filterMap.addListener((MapChangeListener)new MapChangeListener<String, Object>(){

            public void onChanged(MapChangeListener.Change<? extends String, ?> change) {
                PagedQuery.this.fullRefresh = true;
                PagedQuery.this.filterRefresh = true;
            }
        });
        this.filter = new SimpleObjectProperty((Object)this, "filter");
    }

    public ObjectProperty<F> filterProperty() {
        return this.filter;
    }

    @Override
    public F getFilter() {
        if (this.filter.get() != null) {
            return (F)this.filter.get();
        }
        try {
            return (F)this.filterMap;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public void setFilter(F filter) {
        if (filter == null) {
            this.internalFilterMap.clear();
        } else {
            this.filter.set(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected F cloneFilter() {
        if (this.filter.get() != null) {
            return (F)this.filter.get();
        }
        Map<String, Object> map = this.internalFilterMap;
        synchronized (map) {
            return (F)new HashMap<String, Object>(this.internalFilterMap);
        }
    }

    public boolean setAll(Collection<? extends E> coll) {
        if (!this.initializing) {
            return this.fullRefresh();
        }
        return false;
    }

    @Override
    @PreDestroy
    public void clear() {
        super.clear();
        this.helper.clear();
        this.pageChangeHelper.clear();
    }

    public void addListener(ListChangeListener<? super E> listener) {
        this.helper.addListener(listener);
    }

    public void removeListener(ListChangeListener<? super E> listener) {
        this.helper.removeListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.helper.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.helper.removeListener(listener);
    }

    public void addListener(PageChangeListener<E, F> listener) {
        this.pageChangeHelper.addListener(listener);
    }

    public void removeListener(PageChangeListener<E, F> listener) {
        this.pageChangeHelper.removeListener(listener);
    }

    @Override
    public void firePageChange(TideRpcEvent event, int previousFirst, int previousLast, List<E> savedSnapshot) {
        if (event instanceof TideResultEvent) {
            this.fireItemsUpdated(0, Math.min(this.count, this.last) - this.first, previousFirst, previousLast, savedSnapshot);
        }
        this.pageChangeHelper.fireEvent(this, event);
    }

    public void fireItemsUpdated(final int from, final int to, int previousFrom, int previousTo, final List<E> savedSnapshot) {
        if (savedSnapshot != null) {
            final ArrayList<Integer> removals = new ArrayList<Integer>();
            for (int i = 0; i < savedSnapshot.size(); ++i) {
                if (this.getInternalWrappedList().contains(savedSnapshot.get(i))) continue;
                removals.add(i);
            }
            final ArrayList<Integer> adds = new ArrayList<Integer>();
            if (from == previousFrom && to == previousTo) {
                for (int i = 0; i < this.getInternalWrappedList().size(); ++i) {
                    if (savedSnapshot.contains(this.getInternalWrappedList().get(i))) continue;
                    adds.add(i);
                }
            }
            int start = -1;
            for (int i = 0; i < savedSnapshot.size(); ++i) {
                if (!this.getInternalWrappedList().contains(savedSnapshot.get(i))) continue;
                start = i;
                break;
            }
            ArrayList<Integer> permutations = new ArrayList<Integer>();
            if (start >= 0) {
                int idx;
                for (int i = start; i < savedSnapshot.size() && (idx = this.getInternalWrappedList().indexOf(savedSnapshot.get(i))) >= 0; ++i) {
                    permutations.add(this.first + idx);
                }
            }
            final int[] perms = permutations.size() > 0 ? new int[permutations.size()] : null;
            for (int i = 0; i < permutations.size(); ++i) {
                perms[i] = (Integer)permutations.get(i);
            }
            final int permutationStart = start;
            ListChangeListener.Change change = new ListChangeListener.Change<E>(this.wrappedList){
                private int changeIndex;
                {
                    super(x0);
                    this.changeIndex = -1;
                }

                public int getFrom() {
                    if (this.changeIndex < removals.size()) {
                        return PagedQuery.this.first + (Integer)removals.get(this.changeIndex);
                    }
                    if (this.changeIndex >= removals.size() && this.changeIndex < removals.size() + adds.size()) {
                        return PagedQuery.this.first + (Integer)adds.get(this.changeIndex);
                    }
                    if (perms != null) {
                        return PagedQuery.this.first + permutationStart;
                    }
                    return -1;
                }

                public int getTo() {
                    if (this.changeIndex < removals.size()) {
                        return PagedQuery.this.first + (Integer)removals.get(this.changeIndex);
                    }
                    if (this.changeIndex >= removals.size() && this.changeIndex < removals.size() + adds.size()) {
                        return PagedQuery.this.first + (Integer)adds.get(this.changeIndex);
                    }
                    if (perms != null) {
                        return PagedQuery.this.first + permutationStart + perms.length;
                    }
                    return -1;
                }

                public boolean wasUpdated() {
                    return false;
                }

                public boolean wasAdded() {
                    return this.changeIndex >= removals.size() && this.changeIndex < removals.size() + adds.size();
                }

                public int getAddedSize() {
                    if (this.changeIndex >= removals.size() && this.changeIndex < removals.size() + adds.size()) {
                        return 1;
                    }
                    return -1;
                }

                public List<E> getAddedSubList() {
                    if (this.changeIndex >= removals.size() && this.changeIndex < removals.size() + adds.size()) {
                        return PagedQuery.this.internalWrappedList.subList((Integer)adds.get(this.changeIndex), (Integer)adds.get(this.changeIndex) + 1);
                    }
                    return Collections.emptyList();
                }

                protected int[] getPermutation() {
                    if (this.changeIndex == removals.size() + adds.size()) {
                        return perms;
                    }
                    return EMPTY_PERMUTATION;
                }

                public int getPermutation(int i) {
                    if (this.changeIndex < removals.size() + adds.size()) {
                        throw new IllegalStateException("Not a permutation change");
                    }
                    if (i - this.getFrom() >= 0 && i - this.getFrom() < perms.length) {
                        return perms[i - this.getFrom()];
                    }
                    return -1;
                }

                public boolean wasRemoved() {
                    return this.changeIndex < removals.size();
                }

                public List<E> getRemoved() {
                    if (this.changeIndex < removals.size()) {
                        return Collections.singletonList(savedSnapshot.get((Integer)removals.get(this.changeIndex)));
                    }
                    return Collections.emptyList();
                }

                public boolean next() {
                    ++this.changeIndex;
                    return perms != null ? this.changeIndex <= removals.size() + adds.size() : this.changeIndex < removals.size() + adds.size();
                }

                public void reset() {
                    this.changeIndex = -1;
                }
            };
            this.helper.fireValueChangedEvent(change);
            return;
        }
        if (to < from) {
            return;
        }
        ListChangeListener.Change change = new ListChangeListener.Change<E>(this.wrappedList){
            private boolean next;
            {
                super(x0);
                this.next = true;
            }

            public int getFrom() {
                return from;
            }

            public int getTo() {
                return to;
            }

            public boolean wasUpdated() {
                return true;
            }

            protected int[] getPermutation() {
                return EMPTY_PERMUTATION;
            }

            public List<E> getRemoved() {
                return Collections.emptyList();
            }

            public boolean next() {
                if (this.next) {
                    this.next = false;
                    return true;
                }
                return false;
            }

            public void reset() {
                this.next = true;
            }
        };
        this.helper.fireValueChangedEvent(change);
    }

    @Override
    public Object[] toArray() {
        return this.internalWrappedList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.internalWrappedList.toArray(a);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(E ... elements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public void remove(int from, int to) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(E ... elements) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(E ... elements) {
        throw new UnsupportedOperationException();
    }

    public boolean setAll(E ... elements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public class ListChangeWrapper
    extends ListChangeListener.Change<E> {
        private final ListChangeListener.Change<? extends E> wrappedChange;

        public ListChangeWrapper(ObservableList<E> list, ListChangeListener.Change<? extends E> wrappedChange) {
            super(list);
            this.wrappedChange = wrappedChange;
        }

        public int getAddedSize() {
            return this.wrappedChange.getAddedSize();
        }

        public List<E> getAddedSubList() {
            return this.wrappedChange.getAddedSubList();
        }

        public int getRemovedSize() {
            return this.wrappedChange.getRemovedSize();
        }

        public boolean wasAdded() {
            return this.wrappedChange.wasAdded();
        }

        public boolean wasPermutated() {
            return this.wrappedChange.wasPermutated();
        }

        public boolean wasRemoved() {
            return this.wrappedChange.wasRemoved();
        }

        public boolean wasReplaced() {
            return this.wrappedChange.wasReplaced();
        }

        public boolean wasUpdated() {
            return this.wrappedChange.wasUpdated();
        }

        public int getFrom() {
            int from = this.wrappedChange.getFrom();
            return from + PagedQuery.this.first;
        }

        public int getTo() {
            int to = this.wrappedChange.getTo();
            return to + PagedQuery.this.first;
        }

        protected int[] getPermutation() {
            return EMPTY_PERMUTATION;
        }

        public int getPermutation(int num) {
            return this.wrappedChange.getPermutation(num);
        }

        public List<E> getRemoved() {
            return this.wrappedChange.getRemoved();
        }

        public boolean next() {
            return this.wrappedChange.next();
        }

        public void reset() {
            this.wrappedChange.reset();
        }
    }

    public class WrappedListListChangeListener
    implements ListChangeListener<E> {
        public void onChanged(ListChangeListener.Change<? extends E> change) {
            ListChangeWrapper wrappedChange = new ListChangeWrapper(PagedQuery.this.wrappedList, change);
            PagedQuery.this.helper.fireValueChangedEvent(wrappedChange);
        }
    }
}

