/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide.collections;

import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.granite.client.tide.collection.SortAdapter;
import org.granite.tide.data.model.SortInfo;

public class TableViewSortAdapter<S>
implements SortAdapter {
    private TableView<S> tableView;
    private S exampleData;

    public TableViewSortAdapter(TableView<S> tableView, Class<S> exampleDataClass) {
        this.tableView = tableView;
        try {
            this.exampleData = exampleDataClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate example data class " + exampleDataClass, e);
        }
    }

    @Override
    public void apply(SortInfo sortInfo) {
        String[] order = sortInfo.getOrder();
        boolean[] desc = sortInfo.getDesc();
        if (order != null && desc != null) {
            this.tableView.getSortOrder().clear();
            for (int i = 0; i < order.length; ++i) {
                for (TableColumn column : this.tableView.getColumns()) {
                    ObservableValue property = column.getCellObservableValue(this.exampleData);
                    if (!(property instanceof ReadOnlyProperty) || !((ReadOnlyProperty)property).getName().equals(order[i])) continue;
                    this.tableView.getSortOrder().add((Object)column);
                    column.setSortType(desc[i] ? TableColumn.SortType.DESCENDING : TableColumn.SortType.ASCENDING);
                }
            }
        }
    }

    @Override
    public void retrieve(SortInfo sortInfo) {
        int i = 0;
        String[] order = new String[this.tableView.getSortOrder().size()];
        boolean[] desc = new boolean[this.tableView.getSortOrder().size()];
        for (TableColumn column : this.tableView.getSortOrder()) {
            ObservableValue property = column.getCellObservableValue(this.exampleData);
            if (property instanceof ReadOnlyProperty) {
                order[i] = ((ReadOnlyProperty)property).getName();
                desc[i] = column.getSortType() == TableColumn.SortType.DESCENDING;
                ++i;
                continue;
            }
            throw new IllegalArgumentException("Sortable cell values must implement Property to apply TableViewSort adapter");
        }
        sortInfo.setOrder((String[])(order.length > 0 ? order : null));
        sortInfo.setDesc((boolean[])(desc.length > 0 ? desc : null));
    }
}

