/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.tide.spring;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import org.granite.client.javafx.tide.BaseIdentity;
import org.granite.client.javafx.tide.ObservablePermission;
import org.granite.client.javafx.tide.ObservableRole;
import org.granite.client.messaging.RemoteAlias;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.util.WeakIdentityHashMap;

@RemoteAlias(value="org.granite.tide.spring.security.Identity")
@Named
public class Identity
extends BaseIdentity {
    private Map<String, ObservableRole> ifAllGrantedCache = new HashMap<String, ObservableRole>();
    private Map<String, ObservableRole> ifAnyGrantedCache = new HashMap<String, ObservableRole>();
    private Map<String, ObservableRole> ifNotGrantedCache = new HashMap<String, ObservableRole>();
    private Map<Object, Map<String, ObservablePermission>> permissionsCache = new WeakIdentityHashMap();

    public Identity() {
    }

    public Identity(ServerSession serverSession) {
        super(serverSession);
    }

    @Override
    public ObservableRole hasRole(String roleName) {
        return this.ifAllGranted(roleName);
    }

    public ObservableRole ifAllGranted(String roleName) {
        ObservableRole role = this.ifAllGrantedCache.get(roleName);
        if (role == null) {
            role = new ObservableRole(this, this.getContext(), this.getServerSession(), "ifAllGranted", roleName);
            this.ifAllGrantedCache.put(roleName, role);
        }
        return role;
    }

    public ObservableRole ifAnyGranted(String roleName) {
        ObservableRole role = this.ifAnyGrantedCache.get(roleName);
        if (role == null) {
            role = new ObservableRole(this, this.getContext(), this.getServerSession(), "ifAnyGranted", roleName);
            this.ifAnyGrantedCache.put(roleName, role);
        }
        return role;
    }

    public ObservableRole ifNotGranted(String roleName) {
        ObservableRole role = this.ifNotGrantedCache.get(roleName);
        if (role == null) {
            role = new ObservableRole(this, this.getContext(), this.getServerSession(), "ifNotGranted", roleName);
            this.ifNotGrantedCache.put(roleName, role);
        }
        return role;
    }

    public ObservablePermission hasPermission(Object entity, String action) {
        ObservablePermission permission;
        Map<String, ObservablePermission> entityPermissions = this.permissionsCache.get(entity);
        if (entityPermissions == null) {
            entityPermissions = new HashMap<String, ObservablePermission>();
            this.permissionsCache.put(entity, entityPermissions);
        }
        if ((permission = entityPermissions.get(action)) == null) {
            permission = new ObservablePermission(this, this.getContext(), this.getServerSession(), "hasPermission", entity, action);
            entityPermissions.put(action, permission);
        }
        return permission;
    }

    @Override
    protected void initSecurityCache() {
        for (ObservableRole observableRole : this.ifAllGrantedCache.values()) {
            observableRole.clear();
        }
        for (ObservableRole observableRole : this.ifAnyGrantedCache.values()) {
            observableRole.clear();
        }
        for (ObservableRole observableRole : this.ifNotGrantedCache.values()) {
            observableRole.clear();
        }
        for (Map map : this.permissionsCache.values()) {
            for (ObservablePermission permission : map.values()) {
                permission.clear();
            }
        }
    }

    @Override
    public void clearSecurityCache() {
        for (ObservableRole observableRole : this.ifAllGrantedCache.values()) {
            observableRole.clear();
        }
        this.ifAllGrantedCache.clear();
        for (ObservableRole observableRole : this.ifAnyGrantedCache.values()) {
            observableRole.clear();
        }
        this.ifAnyGrantedCache.clear();
        for (ObservableRole observableRole : this.ifNotGrantedCache.values()) {
            observableRole.clear();
        }
        this.ifNotGrantedCache.clear();
        for (Map map : this.permissionsCache.values()) {
            for (ObservablePermission permission : map.values()) {
                permission.clear();
            }
        }
        this.permissionsCache.clear();
    }
}

