/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.util;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import org.granite.client.javafx.util.ListenerUtil;

public class ListListenerHelper<E> {
    private InvalidationListener[] invalidationListeners = null;
    private ListChangeListener<? super E>[] listChangeListeners = null;

    public void addListener(InvalidationListener listener) {
        this.invalidationListeners = ListenerUtil.add(InvalidationListener.class, this.invalidationListeners, listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.invalidationListeners = ListenerUtil.remove(InvalidationListener.class, this.invalidationListeners, listener);
    }

    public void addListener(ListChangeListener<? super E> listener) {
        this.listChangeListeners = ListenerUtil.add(ListChangeListener.class, this.listChangeListeners, listener);
    }

    public void removeListener(ListChangeListener<? super E> listener) {
        this.listChangeListeners = ListenerUtil.remove(ListChangeListener.class, this.listChangeListeners, listener);
    }

    public void fireValueChangedEvent(ListChangeListener.Change<E> change) {
        if (this.invalidationListeners != null) {
            for (InvalidationListener invalidationListener : this.invalidationListeners) {
                invalidationListener.invalidated((Observable)change.getList());
            }
        }
        if (this.listChangeListeners != null) {
            for (InvalidationListener invalidationListener : this.listChangeListeners) {
                change.reset();
                invalidationListener.onChanged(change);
            }
        }
    }

    public boolean hasListeners() {
        return this.invalidationListeners != null || this.listChangeListeners != null;
    }

    public int getInvalidationListenersSize() {
        return this.invalidationListeners.length;
    }

    public int getListChangeListenersListenersSize() {
        return this.listChangeListeners.length;
    }

    public void clear() {
        this.invalidationListeners = null;
        this.listChangeListeners = null;
    }
}

