/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.util;

import java.lang.reflect.Method;
import org.granite.client.javafx.util.ListenerUtil;

public class ListenerHelper<L> {
    private final Class<?> listenerInterface;
    private final Method listenerMethod;
    private L[] listeners = null;

    public ListenerHelper(Class<?> listenerInterface) {
        this.listenerInterface = listenerInterface;
        Method[] methods = listenerInterface.getMethods();
        if (!listenerInterface.isInterface()) {
            throw new RuntimeException("Listener class must be an interface");
        }
        if (methods.length != 1) {
            throw new RuntimeException("Cannot use ListenerHelper with listener interfaces having more than one method");
        }
        this.listenerMethod = methods[0];
    }

    public void addListener(L listener) {
        this.listeners = ListenerUtil.add(this.listenerInterface, this.listeners, listener);
    }

    public void removeListener(L listener) {
        this.listeners = ListenerUtil.remove(this.listenerInterface, this.listeners, listener);
    }

    public void fireEvent(Object ... args) {
        if (this.listeners != null) {
            for (L listener : this.listeners) {
                try {
                    this.listenerMethod.invoke(listener, args);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not fire event", e);
                }
            }
        }
    }

    public boolean hasListeners() {
        return this.listeners != null;
    }

    public void clear() {
        this.listeners = null;
    }
}

