/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import javafx.beans.WeakListener;

public class ListenerUtil {
    public static <T> T[] add(Class<?> listenerInterface, T[] listeners, T listener) {
        if (listeners == null) {
            Object[] newListeners = (Object[])Array.newInstance(listenerInterface, 1);
            newListeners[0] = listener;
            return newListeners;
        }
        for (T l : listeners) {
            if (!listener.equals(l)) continue;
            return listeners;
        }
        int newSize = 0;
        int length = listeners.length;
        for (int i = 0; i < length; ++i) {
            T l;
            l = listeners[i];
            if (l instanceof WeakListener && ((WeakListener)l).wasGarbageCollected()) {
                if (i < length - 1) {
                    System.arraycopy(listeners, i + 1, listeners, i, length - i - 1);
                }
                --length;
                --i;
                continue;
            }
            ++newSize;
        }
        T[] newListeners = Arrays.copyOf(listeners, newSize + 1);
        newListeners[newSize] = listener;
        return newListeners;
    }

    public static <T> T[] remove(Class<?> listenerClass, T[] listeners, T listener) {
        if (listeners == null) {
            return null;
        }
        int index = -1;
        for (int i = 0; i < listeners.length; ++i) {
            if (!listeners[i].equals(listener)) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return listeners;
        }
        if (listeners.length == 1) {
            return null;
        }
        int newSize = 0;
        int length = listeners.length;
        for (int i = 0; i < length; ++i) {
            T l = listeners[i];
            if (l instanceof WeakListener && ((WeakListener)l).wasGarbageCollected() || l.equals(listener)) {
                if (i < length - 1) {
                    System.arraycopy(listeners, i + 1, listeners, i, length - i - 1);
                }
                --length;
                --i;
                continue;
            }
            ++newSize;
        }
        if (newSize == 0) {
            return null;
        }
        return Arrays.copyOf(listeners, newSize);
    }
}

