/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.validation;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TextInputControl;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.groups.Default;
import org.granite.client.javafx.validation.ValidationResult;
import org.granite.client.javafx.validation.ValidationResultEvent;
import org.granite.client.validation.NotifyingValidator;
import org.granite.client.validation.NotifyingValidatorFactory;
import org.granite.logging.Logger;

public class FormValidator {
    private static final Logger log = Logger.getLogger(FormValidator.class);
    public static final String UNHANDLED_VIOLATIONS = "unhandledViolations";
    private ObjectProperty<Object> entity = new SimpleObjectProperty((Object)this, "entity");
    private Parent form;
    private List<Node> inputs = new ArrayList<Node>();
    private Map<Node, Property<?>> inputProperties = new IdentityHashMap();
    private Map<Node, Property<?>> entityProperties = new IdentityHashMap();
    private Set<Node> focusedOutOnce = new HashSet<Node>();
    private List<ConstraintViolation<?>> violations = new ArrayList();
    private ObservableList<ConstraintViolation<?>> unhandledViolations = FXCollections.observableArrayList();
    private final NotifyingValidator validator;
    public BooleanProperty validateOnChangeProperty = new SimpleBooleanProperty((Object)this, "validateOnChange", true);
    public Class<?>[] groups = new Class[]{Default.class};
    private ListChangeListener<Node> childChangeListener = new ChildChangeListener();
    private IdentityHashMap<Node, Boolean> trackedNodes = new IdentityHashMap();
    private ChangeListener<Boolean> inputFocusChangeListener = new InputFocusChangeListener();
    private ChangeListener<Object> valueChangeListener = new ValueChangeListener();
    private NotifyingValidator.ConstraintViolationsHandler<Object> constraintViolationHandler = new ConstraintViolationHandlerImpl();

    public FormValidator(NotifyingValidatorFactory validatorFactory) {
        this.validator = validatorFactory.getValidator();
        this.entity.addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> object, Object oldValue, Object newValue) {
                if (FormValidator.this.form == null) {
                    return;
                }
                FormValidator.this.setupForm(null);
                FormValidator.this.setupForm(FormValidator.this.form);
            }
        });
    }

    public ObjectProperty<Object> entityProperty() {
        return this.entity;
    }

    public Object getEntity() {
        return this.entity;
    }

    public boolean isValidateOnChange() {
        return this.validateOnChangeProperty.get();
    }

    public void setValidateOnChange(boolean validateOnChange) {
        this.validateOnChangeProperty.set(validateOnChange);
    }

    public Parent getForm() {
        return this.form;
    }

    public void setForm(Parent form) {
        if (form == this.form) {
            return;
        }
        if (this.form != null) {
            this.setupForm(null);
        }
        this.form = form;
        if (this.form != null) {
            this.setupForm(this.form);
        }
    }

    public List<ConstraintViolation<?>> getViolations() {
        return this.violations;
    }

    public List<ConstraintViolation<?>> getUnhandledViolations() {
        return this.unhandledViolations;
    }

    protected void setupForm(Parent form) {
        this.untrackNode((Node)this.form);
        if (!this.inputs.isEmpty()) {
            this.inputs.clear();
            log.warn("Inputs were not cleared correctly", new Object[0]);
        }
        if (!this.inputProperties.isEmpty()) {
            this.inputProperties.clear();
            log.warn("Input properties were not cleared correctly", new Object[0]);
        }
        if (!this.entityProperties.isEmpty()) {
            this.entityProperties.clear();
            log.warn("Entity properties were not cleared correctly", new Object[0]);
        }
        if (!this.trackedNodes.isEmpty()) {
            this.trackedNodes.clear();
            log.warn("Tracked parents were not cleared correctly", new Object[0]);
        }
        this.focusedOutOnce.clear();
        if (form != null) {
            this.trackNode((Node)form);
        }
    }

    protected void trackNode(Node node) {
        if (this.form == null) {
            return;
        }
        if (this.trackedNodes.containsKey(node)) {
            return;
        }
        this.setupNode(node);
        this.trackedNodes.put(node, Boolean.TRUE);
        if (node instanceof Skinnable && ((Skinnable)node).getSkin() != null && ((Skinnable)node).getSkin().getNode() != node) {
            this.trackNode(((Skinnable)node).getSkin().getNode());
        }
        if (node instanceof Parent) {
            for (Node child : ((Parent)node).getChildrenUnmodifiable()) {
                this.trackNode(child);
            }
            ((Parent)node).getChildrenUnmodifiable().addListener(this.childChangeListener);
            log.debug("Setup children tracking for parent %s", new Object[]{node});
        }
    }

    protected void untrackNode(Node node) {
        if (this.form == null) {
            return;
        }
        if (!this.trackedNodes.containsKey(node)) {
            return;
        }
        this.unsetupNode(node);
        this.trackedNodes.remove(node);
        if (node instanceof Parent) {
            ((Parent)node).getChildrenUnmodifiable().removeListener(this.childChangeListener);
            log.debug("Unset children tracking for parent %s", new Object[]{node.toString()});
            for (Node child : ((Parent)node).getChildrenUnmodifiable()) {
                this.untrackNode(child);
            }
        }
        if (node instanceof Skinnable && ((Skinnable)node).getSkin() != null && ((Skinnable)node).getSkin().getNode() != node) {
            this.untrackNode(((Skinnable)node).getSkin().getNode());
        }
    }

    private void setupNode(Node node) {
        Property<?> entityProperty;
        if (this.inputProperties.containsKey(node)) {
            Property<?> entityProperty2 = this.entityProperties.remove(node);
            Property<?> inputProperty = this.inputProperties.remove(node);
            if (entityProperty2 != null && entityProperty2.getBean() != null) {
                this.validator.removeConstraintViolationsHandler(entityProperty2.getBean(), this.constraintViolationHandler);
            }
            inputProperty.removeListener(this.valueChangeListener);
            node.focusedProperty().removeListener(this.inputFocusChangeListener);
            this.inputs.remove(node);
            log.debug("Cleanup old tracking for fantom node %s input %s entity %s", new Object[]{node, inputProperty.getName(), entityProperty2});
        }
        StringProperty inputProperty = null;
        if (node instanceof TextInputControl) {
            inputProperty = ((TextInputControl)node).textProperty();
        }
        if (inputProperty != null && (entityProperty = this.lookupBindingTarget((Property<?>)inputProperty)) != null) {
            this.inputProperties.put(node, (Property<?>)inputProperty);
            this.entityProperties.put(node, entityProperty);
            if (entityProperty.getBean() != null) {
                this.validator.addConstraintViolationsHandler(entityProperty.getBean(), this.constraintViolationHandler);
            }
            inputProperty.addListener(this.valueChangeListener);
            node.focusedProperty().addListener(this.inputFocusChangeListener);
            this.inputs.add(node);
            log.debug("Setup tracking for node %s input %s entity %s", new Object[]{node, inputProperty.getName(), entityProperty});
        }
    }

    private void unsetupNode(Node node) {
        int idx = this.inputs.indexOf(node);
        if (idx >= 0) {
            Property<?> entityProperty = this.entityProperties.remove(node);
            if (entityProperty.getBean() != null) {
                this.validator.removeConstraintViolationsHandler(entityProperty.getBean(), this.constraintViolationHandler);
            }
            node.fireEvent((Event)new ValidationResultEvent(this, (EventTarget)node, ValidationResultEvent.VALID, null));
            if (node instanceof TextInputControl) {
                ((TextInputControl)node).textProperty().removeListener(this.valueChangeListener);
            }
            node.focusedProperty().removeListener(this.inputFocusChangeListener);
            Property<?> inputProperty = this.inputProperties.remove(node);
            this.inputs.remove(idx);
            log.debug("Unsetup tracking for node %s input %s entity %s", new Object[]{node, inputProperty.getName(), entityProperty});
        }
    }

    private Property<?> lookupBindingTarget(Property<?> inputProperty) {
        try {
            Field fh = inputProperty.getClass().getDeclaredField("helper");
            fh.setAccessible(true);
            Object helper = fh.get(inputProperty);
            Field fcl = helper.getClass().getDeclaredField("changeListeners");
            fcl.setAccessible(true);
            Object changeListeners = fcl.get(helper);
            if (changeListeners != null && Array.getLength(changeListeners) > 0) {
                ChangeListener cl = (ChangeListener)Array.get(changeListeners, 0);
                try {
                    Field fpr = cl.getClass().getDeclaredField("propertyRef2");
                    fpr.setAccessible(true);
                    WeakReference ref = (WeakReference)fpr.get(cl);
                    Property p = (Property)ref.get();
                    return p;
                }
                catch (NoSuchFieldException e) {
                    log.debug("Field propertyRef2 not found on " + cl + ", probably not a standard binding", new Object[]{e});
                    return null;
                }
            }
            log.debug("Could not find target binding for property %s", new Object[]{inputProperty});
            return null;
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Could not find target binding for property %s", new Object[]{inputProperty});
            return null;
        }
    }

    protected boolean validateValue(Node input, boolean focusOut) {
        Class<?> entityClass;
        Set<ConstraintViolation<Object>> violations;
        Property<?> entityProperty = this.entityProperties.get(input);
        Property<?> inputProperty = this.inputProperties.get(input);
        if (entityProperty == null || inputProperty == null) {
            log.warn("validateValue called for untracked input " + input, new Object[0]);
            return true;
        }
        if (focusOut) {
            this.focusedOutOnce.add(input);
        }
        boolean nulled = false;
        Object value = inputProperty.getValue();
        if ("".equals(value)) {
            value = null;
            nulled = true;
        }
        if ((violations = this.validator.validateValue(entityClass = entityProperty.getBean().getClass(), entityProperty.getName(), value, this.groups)) == null) {
            violations = Collections.emptySet();
        }
        if (violations.isEmpty() && !nulled) {
            this.focusedOutOnce.add(input);
        } else if (!this.focusedOutOnce.contains(input)) {
            return true;
        }
        this.handleViolations(input, violations);
        return violations.isEmpty();
    }

    protected void handleViolations(Node input, Set<ConstraintViolation<Object>> violations) {
        ArrayList<ValidationResultEvent> resultEvents = new ArrayList<ValidationResultEvent>();
        if (input != null) {
            if (!violations.isEmpty()) {
                ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
                for (ConstraintViolation constraintViolation : violations) {
                    results.add(new ValidationResult(true, this.entityProperties.get(input), "constraintViolation", constraintViolation.getMessage()));
                }
                resultEvents.add(new ValidationResultEvent(this, (EventTarget)input, ValidationResultEvent.INVALID, results));
            } else {
                resultEvents.add(new ValidationResultEvent(this, (EventTarget)input, ValidationResultEvent.VALID, null));
            }
        } else {
            HashSet<ConstraintViolation<Object>> unhandledViolations = new HashSet<ConstraintViolation<Object>>(violations);
            for (Node node : this.inputs) {
                ArrayList<ValidationResult> arrayList = new ArrayList<ValidationResult>();
                Property<?> property = this.entityProperties.get(node);
                Iterator iv = unhandledViolations.iterator();
                while (iv.hasNext()) {
                    ConstraintViolation violation = (ConstraintViolation)iv.next();
                    Iterator in = violation.getPropertyPath().iterator();
                    Path.Node n = null;
                    while (in.hasNext()) {
                        n = (Path.Node)in.next();
                    }
                    if (!violation.getLeafBean().equals(property.getBean()) || !n.getName().equals(property.getName())) continue;
                    ValidationResult result = new ValidationResult(true, property, "constraintViolation", violation.getMessage());
                    arrayList.add(result);
                    iv.remove();
                }
                if (arrayList.isEmpty()) {
                    resultEvents.add(new ValidationResultEvent(this, (EventTarget)node, ValidationResultEvent.VALID, null));
                    continue;
                }
                resultEvents.add(new ValidationResultEvent(this, (EventTarget)node, ValidationResultEvent.INVALID, arrayList));
            }
            this.unhandledViolations.clear();
            if (!unhandledViolations.isEmpty()) {
                this.unhandledViolations.addAll(unhandledViolations);
                ArrayList<ValidationResult> unhandledResults = new ArrayList<ValidationResult>();
                for (ConstraintViolation constraintViolation : unhandledViolations) {
                    unhandledResults.add(new ValidationResult(true, null, "constraintViolation", constraintViolation.getMessage()));
                }
                resultEvents.add(new ValidationResultEvent(this, (EventTarget)this.form, ValidationResultEvent.UNHANDLED, unhandledResults));
            }
        }
        for (ValidationResultEvent resultEvent : resultEvents) {
            ((Node)resultEvent.getTarget()).fireEvent((Event)resultEvent);
        }
    }

    private class ConstraintViolationHandlerImpl
    implements NotifyingValidator.ConstraintViolationsHandler<Object> {
        private ConstraintViolationHandlerImpl() {
        }

        @Override
        public void handle(Object entity, Set<ConstraintViolation<Object>> violations) {
            FormValidator.this.focusedOutOnce.addAll(FormValidator.this.inputs);
            if (violations == null) {
                return;
            }
            for (ConstraintViolation<Object> violation : violations) {
                Object leafBean = violation.getLeafBean();
                String property = null;
                for (Path.Node n : violation.getPropertyPath()) {
                    property = n.getName();
                }
                String[] path = property.split("\\.");
                property = path[path.length - 1];
                Node input = null;
                for (Map.Entry me : FormValidator.this.entityProperties.entrySet()) {
                    if (leafBean == null || !leafBean.equals(((Property)me.getValue()).getBean()) || !((Property)me.getValue()).getName().equals(property)) continue;
                    input = (Node)me.getKey();
                    break;
                }
                if (input == null) continue;
                List<ValidationResult> results = Collections.singletonList(new ValidationResult(true, (Property)FormValidator.this.entityProperties.get(input), "constraintViolation", violation.getMessage()));
                input.fireEvent((Event)new ValidationResultEvent(this, (EventTarget)input, ValidationResultEvent.INVALID, results));
            }
        }
    }

    private class ValueChangeListener
    implements ChangeListener<Object> {
        private ValueChangeListener() {
        }

        public void changed(ObservableValue<?> change, Object oldValue, Object newValue) {
            if (FormValidator.this.validateOnChangeProperty.get()) {
                FormValidator.this.validateValue((Node)((Property)change).getBean(), false);
            }
        }
    }

    private class InputFocusChangeListener
    implements ChangeListener<Boolean> {
        private InputFocusChangeListener() {
        }

        public void changed(ObservableValue<? extends Boolean> change, Boolean oldValue, Boolean newValue) {
            if (Boolean.TRUE.equals(oldValue) && Boolean.FALSE.equals(newValue)) {
                FormValidator.this.validateValue((Node)((ReadOnlyBooleanProperty)change).getBean(), true);
            }
        }
    }

    public class ChildChangeListener
    implements ListChangeListener<Node> {
        public void onChanged(ListChangeListener.Change<? extends Node> change) {
            while (change.next()) {
                if (change.wasReplaced() && change.getRemovedSize() == 1 && change.getAddedSize() == 1 && change.getAddedSubList().get(0) == change.getRemoved().get(0)) continue;
                if (change.wasRemoved()) {
                    for (Node node : change.getRemoved()) {
                        FormValidator.this.untrackNode(node);
                    }
                }
                if (change.wasAdded()) {
                    for (Node node : change.getAddedSubList()) {
                        FormValidator.this.trackNode(node);
                    }
                }
                if (!change.wasPermutated()) continue;
                log.debug("Permutation ??", new Object[0]);
            }
        }
    }
}

