/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.granite.client.tide.Context;
import org.granite.client.tide.InstanceStore;
import org.granite.client.tide.InstanceStoreFactory;
import org.granite.client.tide.impl.InstanceFactory;

public class CDIInstanceStoreFactory
implements InstanceStoreFactory {
    private final BeanManager beanManager;

    public CDIInstanceStoreFactory(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    @Override
    public InstanceStore createStore(Context context, InstanceFactory instanceFactory) {
        return new CDIInstanceStore(context, this.beanManager);
    }

    public static class CDIInstanceStore
    implements InstanceStore {
        private final Context context;
        private final BeanManager beanManager;

        public CDIInstanceStore(Context context, BeanManager beanManager) {
            this.context = context;
            this.beanManager = beanManager;
        }

        @Override
        public void init() {
        }

        @Override
        public <T> T getNoProxy(String name, Context context) {
            Set beans = this.beanManager.getBeans(name);
            if (beans.size() == 0) {
                return null;
            }
            if (beans.size() > 1) {
                throw new RuntimeException("Ambiguous beans found " + name);
            }
            Bean bean = (Bean)beans.iterator().next();
            CreationalContext cc = this.beanManager.createCreationalContext((Contextual)bean);
            return (T)this.beanManager.getReference(bean, Object.class, cc);
        }

        @Override
        public boolean exists(String name) {
            return this.beanManager.getBeans(name).size() > 0;
        }

        @Override
        public <T> T byName(String name, Context context) {
            Set beans = this.beanManager.getBeans(name);
            if (beans.size() == 0) {
                return null;
            }
            if (beans.size() > 1) {
                throw new RuntimeException("Ambiguous beans found " + name);
            }
            Bean bean = (Bean)beans.iterator().next();
            CreationalContext cc = this.beanManager.createCreationalContext((Contextual)bean);
            return (T)this.beanManager.getReference(bean, Object.class, cc);
        }

        @Override
        public <T> T byType(Class<T> type, Context context) {
            Set beans = this.beanManager.getBeans(type, new Annotation[0]);
            if (beans.size() == 0) {
                return null;
            }
            if (beans.size() > 1) {
                throw new RuntimeException("Ambiguous beans found " + type);
            }
            Bean bean = (Bean)beans.iterator().next();
            CreationalContext cc = this.beanManager.createCreationalContext((Contextual)bean);
            return (T)this.beanManager.getReference(bean, type, cc);
        }

        @Override
        public <T> T[] allByType(Class<T> type, Context context, boolean create) {
            Set beans = this.beanManager.getBeans(type, new Annotation[0]);
            Object[] instances = (Object[])Array.newInstance(type, beans.size());
            int i = 0;
            for (Bean bean : beans) {
                CreationalContext cc = this.beanManager.createCreationalContext((Contextual)bean);
                instances[i++] = this.beanManager.getReference(bean, type, cc);
            }
            return instances;
        }

        @Override
        public Map<String, Object> allByAnnotatedWith(Class<? extends Annotation> annotationClass, Context context) {
            Set beans = this.beanManager.getBeans(Object.class, new Annotation[0]);
            HashSet<Bean> filtered = new HashSet<Bean>();
            block0: for (Bean bean : beans) {
                if (bean.getName() == null) continue;
                for (Annotation annotation : bean.getQualifiers()) {
                    if (!annotation.annotationType().equals(annotationClass)) continue;
                    filtered.add(bean);
                    continue block0;
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Bean bean : filtered) {
                CreationalContext cc = this.beanManager.createCreationalContext((Contextual)bean);
                map.put(bean.getName(), this.beanManager.getReference(bean, Object.class, cc));
            }
            return map;
        }

        @Override
        public List<String> allNames() {
            Set beans = this.beanManager.getBeans(Object.class, new Annotation[0]);
            ArrayList<String> names = new ArrayList<String>();
            for (Bean bean : beans) {
                if (bean.getName() == null) continue;
                names.add(bean.getName());
            }
            return names;
        }

        @Override
        public <T> T set(String name, T instance) {
            return instance;
        }

        @Override
        public <T> T set(T instance) {
            return instance;
        }

        @Override
        public void remove(String name) {
        }

        @Override
        public void remove(Object instance) {
        }

        @Override
        public void clear() {
        }

        @Override
        public void inject(Object instance, String name, Map<String, Object> properties) {
        }
    }
}

