/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.cdi;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.granite.client.tide.ViewScope;
import org.granite.client.tide.ViewScopeHolder;
import org.granite.client.tide.cdi.ViewScoped;

public class ViewContext
implements Context {
    private ViewScope beanCache;

    private ViewScope getBeanCache() {
        if (this.beanCache == null) {
            this.beanCache = ViewScopeHolder.get();
            if (this.beanCache == null) {
                throw new RuntimeException("View bean cache not set");
            }
        }
        return this.beanCache;
    }

    public <T> T get(Contextual<T> bean) {
        return this.get(bean, null);
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> cc) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (bean == null) {
            throw new IllegalArgumentException("bean cannot be null");
        }
        String id = this.buildId(bean);
        Object instance = this.getBeanCache().get(id);
        if (instance != null) {
            return (T)instance;
        }
        if (cc == null) {
            return null;
        }
        instance = bean.create(cc);
        this.getBeanCache().put(id, instance);
        this.getBeanCache().addResetter(id, new ViewBeanResetter<T>(bean, cc));
        return (T)instance;
    }

    private <T> String buildId(Contextual<T> contextual) {
        return contextual.getClass().getName() + "#" + contextual.hashCode();
    }

    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    public boolean isActive() {
        return this.getBeanCache() != null;
    }

    public static class ViewBeanResetter<T>
    implements ViewScope.BeanResetter {
        private final Contextual<T> bean;
        private final CreationalContext<T> cc;

        public ViewBeanResetter(Contextual<T> bean, CreationalContext<T> cc) {
            this.bean = bean;
            this.cc = cc;
        }

        @Override
        public void reset(Object instance) {
            this.bean.destroy(instance, this.cc);
        }
    }
}

