/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.granite.client.messaging.ClientAliasRegistry;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.Utils;
import org.granite.client.tide.data.Value;
import org.granite.client.tide.data.impl.ObjectUtil;
import org.granite.client.tide.data.spi.DataManager;
import org.granite.client.tide.server.ServerSession;
import org.granite.tide.IUID;
import org.granite.tide.data.Change;
import org.granite.tide.data.ChangeRef;
import org.granite.tide.data.ChangeSet;
import org.granite.tide.data.CollectionChange;
import org.granite.tide.data.CollectionChanges;

public class ChangeSetBuilder {
    private final EntityManager entityManager;
    private final DataManager dataManager;
    private final ServerSession serverSession;
    private final ClientAliasRegistry aliasRegistry;
    private final Map<Object, Map<String, Object>> savedProperties;
    private final boolean local;
    private EntityManager tmpEntityManager = null;

    public ChangeSetBuilder(EntityManager entityManager, ServerSession serverSession) {
        this(entityManager, serverSession, true);
    }

    public ChangeSetBuilder(EntityManager entityManager, ServerSession serverSession, boolean local) {
        this.entityManager = entityManager;
        this.dataManager = entityManager.getDataManager();
        this.serverSession = serverSession;
        this.aliasRegistry = serverSession.getAliasRegistry();
        this.savedProperties = entityManager.getSavedProperties();
        this.local = local;
        this.tmpEntityManager = entityManager.newTemporaryEntityManager();
    }

    public ChangeSet buildChangeSet() {
        return this.internalBuildChangeSet(this.savedProperties);
    }

    public ChangeSet buildEntityChangeSet(Object entity) {
        IdentityHashMap<Object, Map<String, Object>> entitySavedProperties = new IdentityHashMap<Object, Map<String, Object>>();
        this.collectEntitySavedProperties(entity, entitySavedProperties, null);
        if (!entitySavedProperties.containsKey(entity)) {
            HashMap<String, Object> sp = new HashMap<String, Object>();
            sp.put(this.dataManager.getVersionPropertyName(entity), this.dataManager.getVersion(entity));
            entitySavedProperties.put(entity, sp);
        }
        ChangeSet changeSet = this.internalBuildChangeSet(entitySavedProperties);
        int pos = 0;
        for (int i = 0; i < changeSet.getChanges().length; ++i) {
            if (!this.isForEntity(changeSet.getChanges()[i], entity)) continue;
            pos = i;
            break;
        }
        if (pos > 0) {
            Change change = changeSet.getChanges()[pos];
            System.arraycopy(changeSet.getChanges(), 0, changeSet.getChanges(), 1, pos);
            changeSet.getChanges()[0] = change;
        }
        return changeSet;
    }

    private String getType(String alias) {
        String className = this.aliasRegistry.getTypeForAlias(alias);
        return className != null ? className : alias;
    }

    private String getAlias(String className) {
        String alias = this.aliasRegistry.getAliasForType(className);
        return alias != null ? alias : className;
    }

    private boolean isForEntity(Change change, Object entity) {
        return entity.getClass().getName().equals(this.getType(change.getClassName())) && change.getUid().equals(this.dataManager.getUid(entity));
    }

    private boolean isEntity(Object entity) {
        return this.entityManager.getDataManager().isEntity(entity);
    }

    private void collectEntitySavedProperties(Object entity, Map<Object, Map<String, Object>> savedProperties, Map<Object, Boolean> cache) {
        if (cache == null) {
            cache = new IdentityHashMap<Object, Boolean>();
        } else if (cache.containsKey(entity)) {
            return;
        }
        cache.put(entity, true);
        if (this.isEntity(entity) && this.savedProperties.containsKey(entity)) {
            savedProperties.put(entity, this.savedProperties.get(entity));
        }
        Map<String, Object> properties = this.dataManager.getPropertyValues(entity, false, false);
        for (Object v : properties.values()) {
            if (v == null || this.isEntity(entity) && !this.dataManager.isInitialized(v)) continue;
            if (v instanceof Collection) {
                for (Object e : (Collection)v) {
                    this.collectEntitySavedProperties(e, savedProperties, cache);
                }
                continue;
            }
            if (v instanceof Map) {
                for (Map.Entry entry : ((Map)v).entrySet()) {
                    this.collectEntitySavedProperties(entry.getKey(), savedProperties, cache);
                    this.collectEntitySavedProperties(entry.getValue(), savedProperties, cache);
                }
                continue;
            }
            if (ObjectUtil.isSimple(v) || v instanceof Enum || v instanceof Value || v instanceof byte[]) continue;
            this.collectEntitySavedProperties(v, savedProperties, cache);
        }
    }

    private ChangeSet internalBuildChangeSet(Map<Object, Map<String, Object>> savedProperties) {
        ChangeSet changeSet = new ChangeSet(new Change[0], this.local);
        IdentityHashMap<Object, Boolean> changeMap = new IdentityHashMap<Object, Boolean>();
        for (Map.Entry<Object, Map<String, Object>> mes : savedProperties.entrySet()) {
            Object[] entity = mes.getKey();
            if (!this.isEntity(entity) && !(entity instanceof IUID)) {
                entity = this.entityManager.getOwnerEntity(entity);
            }
            if (changeMap.containsKey(entity)) continue;
            Map<String, Object> save = mes.getValue();
            Change change = null;
            String versionPropertyName = null;
            if (this.isEntity(entity)) {
                versionPropertyName = this.dataManager.getVersionPropertyName(entity);
                if (save.get(versionPropertyName) == null) continue;
                change = new Change(this.getAlias(entity.getClass().getName()), this.dataManager.hasIdProperty(entity) ? (Serializable)this.dataManager.getId(entity) : null, (Number)this.dataManager.getVersion(entity), this.dataManager.getUid(entity), this.local);
            } else if (entity instanceof IUID) {
                change = new Change(this.getAlias(entity.getClass().getName()), null, null, this.dataManager.getUid(entity), this.local);
            }
            if (change == null) {
                changeMap.put(entity, false);
                continue;
            }
            changeMap.put(entity, (Boolean)change);
            Change[] changes = new Change[changeSet.getChanges().length + 1];
            System.arraycopy(changeSet.getChanges(), 0, changes, 0, changeSet.getChanges().length);
            changes[changeSet.getChanges().length] = change;
            changeSet.setChanges(changes);
            for (Map.Entry<String, Object> me : this.dataManager.getPropertyValues(entity, true, true, false).entrySet()) {
                String p = me.getKey();
                Object v = me.getValue();
                if (save != null && save.containsKey(p)) {
                    if (v instanceof Collection || v instanceof Map) {
                        List collSnapshot = (List)save.get(p);
                        CollectionChanges collChanges = new CollectionChanges();
                        change.getChanges().put(p, collChanges);
                        List<Object[]> diffOps = null;
                        diffOps = v instanceof Map ? Utils.diffMaps(Utils.convertMapSnapshot(collSnapshot), (Map)v) : (v instanceof List ? Utils.diffLists(collSnapshot, (List)v) : Utils.diffColls(collSnapshot, (Collection)v));
                        CollectionChange[] collectionChanges = new CollectionChange[diffOps.size()];
                        int idx = 0;
                        for (Object[] op : diffOps) {
                            collectionChanges[idx++] = new CollectionChange(((Integer)op[0]).intValue(), this.buildRef(op[1]), this.buildRef(op[2]));
                        }
                        collChanges.setChanges(collectionChanges);
                        continue;
                    }
                    change.getChanges().put(p, this.buildRef(v));
                    continue;
                }
                if (!savedProperties.containsKey(v) || this.isEntity(v) || v instanceof IUID) continue;
                change.getChanges().put(p, v);
                changeMap.put(v, false);
            }
        }
        this.tmpEntityManager.clear();
        return changeSet;
    }

    private Object buildRef(Object object) {
        if (!this.isEntity(object)) {
            return object;
        }
        if (!this.dataManager.hasVersionProperty(object)) {
            throw new IllegalArgumentException("Cannot build ChangeSet for non versioned entity " + object.getClass().getName());
        }
        if (this.dataManager.getVersion(object) != null) {
            return new ChangeRef(this.getAlias(object.getClass().getName()), this.dataManager.getUid(object), (Serializable)this.dataManager.getId(object));
        }
        this.entityManager.attach(object);
        return this.tmpEntityManager.mergeFromEntityManager(this.entityManager, this.serverSession, object, null, true);
    }
}

