/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data;

import java.util.ArrayList;
import java.util.List;
import org.granite.client.tide.data.Conflict;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.server.ServerSession;
import org.granite.logging.Logger;

public class Conflicts {
    private static Logger log = Logger.getLogger((String)"org.granite.client.tide.data.Conflicts");
    private final EntityManager entityManager;
    private final ServerSession serverSession;
    private List<Conflict> conflicts = new ArrayList<Conflict>();

    public Conflicts(EntityManager entityManager, ServerSession serverSession) {
        this.entityManager = entityManager;
        this.serverSession = serverSession;
    }

    public void addConflict(Object localEntity, Object receivedEntity, List<String> properties) {
        Conflict conflict = new Conflict(this, localEntity, receivedEntity, properties);
        this.conflicts.add(conflict);
    }

    public List<Conflict> getConflicts() {
        return this.conflicts;
    }

    public ServerSession getServerSession() {
        return this.serverSession;
    }

    public boolean isEmpty() {
        return this.conflicts.size() == 0;
    }

    public boolean isAllResolved() {
        for (Conflict c : this.conflicts) {
            if (c.isResolved()) continue;
            return false;
        }
        return true;
    }

    public void acceptClient(Conflict conflict) {
        this.entityManager.acceptConflict(conflict, true);
    }

    public void acceptAllClient() {
        for (Conflict c : this.conflicts) {
            this.acceptClient(c);
        }
    }

    public void acceptServer(Conflict conflict) {
        this.entityManager.acceptConflict(conflict, false);
    }

    public void acceptAllServer() {
        for (Conflict c : this.conflicts) {
            this.acceptServer(c);
        }
    }
}

