/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data;

import java.util.List;
import java.util.Map;
import org.granite.client.tide.Context;
import org.granite.client.tide.data.Conflict;
import org.granite.client.tide.data.DataConflictListener;
import org.granite.client.tide.data.RemoteInitializer;
import org.granite.client.tide.data.RemoteValidator;
import org.granite.client.tide.data.spi.DataManager;
import org.granite.client.tide.data.spi.MergeContext;
import org.granite.client.tide.server.ServerSession;

public interface EntityManager {
    public String getId();

    public boolean isActive();

    public void clearCache();

    public void clear();

    public DataManager getDataManager();

    public DataManager.TrackingHandler getTrackingHandler();

    public void setUninitializeAllowed(boolean var1);

    public boolean isUninitializeAllowed();

    public void setRemoteInitializer(RemoteInitializer var1);

    public void setRemoteValidator(RemoteValidator var1);

    public EntityManager newTemporaryEntityManager();

    public void addReference(Object var1, Object var2, String var3);

    public boolean removeReference(Object var1, Object var2, String var3);

    public boolean isDirty();

    public boolean isDirtyEntity(Object var1);

    public boolean isDeepDirtyEntity(Object var1);

    public boolean isPersisted(Object var1);

    public Object getCachedObject(Object var1, boolean var2);

    public Object[] getOwnerEntity(Object var1);

    public MergeContext initMerge(ServerSession var1);

    public Object mergeExternal(MergeContext var1, Object var2, Object var3, Object var4, String var5, boolean var6);

    public Object mergeExternalData(Object var1, Object var2, String var3, List<Object> var4, List<Object> var5);

    public Object mergeExternalData(ServerSession var1, Object var2);

    public Object mergeExternalData(ServerSession var1, Object var2, Object var3, String var4, List<Object> var5, List<Object> var6);

    public Object mergeExternalData(Object var1);

    public Object mergeFromEntityManager(EntityManager var1, ServerSession var2, Object var3, String var4, boolean var5);

    public void mergeInEntityManager(EntityManager var1, ServerSession var2);

    public void attach(Object var1);

    public void resetEntity(Object var1);

    public void resetAllEntities();

    public Map<Object, Map<String, Object>> getSavedProperties();

    public Map<String, Object> getSavedProperties(Object var1);

    public void handleUpdates(MergeContext var1, String var2, List<Update> var3);

    public void raiseUpdateEvents(Context var1, List<Update> var2);

    public void addListener(DataConflictListener var1);

    public void removeListener(DataConflictListener var1);

    public void acceptConflict(Conflict var1, boolean var2);

    public boolean initializeObject(ServerSession var1, Object var2, String var3, Object var4);

    public boolean validateObject(Object var1, String var2, Object var3);

    public void setEntityManagerPropagation(Propagation var1);

    public static interface PropagationPolicy {
        public void propagate();
    }

    public static interface Function {
        public void execute(EntityManager var1, Object var2);
    }

    public static interface Propagation {
        public void propagate(Object var1, Function var2);
    }

    public static class Update {
        private final UpdateKind kind;
        private Object entity;

        public Update(UpdateKind kind, Object entity) {
            this.kind = kind;
            this.entity = entity;
        }

        public UpdateKind getKind() {
            return this.kind;
        }

        public Object getEntity() {
            return this.entity;
        }

        public void setEntity(Object entity) {
            this.entity = entity;
        }

        public static Update forUpdate(String kind, Object entity) {
            return new Update(UpdateKind.forName(kind), entity);
        }

        public String toString() {
            return this.kind.name() + ":" + this.entity;
        }
    }

    public static enum UpdateKind {
        PERSIST,
        UPDATE,
        REMOVE,
        REFRESH,
        CONFLICT;

        private static final String DATA_EVENT_PREFIX = "org.granite.client.tide.data.";

        public static UpdateKind forName(String kind) {
            if ("PERSIST".equals(kind)) {
                return PERSIST;
            }
            if ("UPDATE".equals(kind)) {
                return UPDATE;
            }
            if ("REMOVE".equals(kind)) {
                return REMOVE;
            }
            if ("REFRESH".equals(kind)) {
                return REFRESH;
            }
            throw new IllegalArgumentException("Unknown update kind " + kind);
        }

        public String eventName() {
            return DATA_EVENT_PREFIX + this.name().toLowerCase();
        }

        public <T> String eventName(Class<T> entityClass) {
            return DATA_EVENT_PREFIX + this.name().toLowerCase() + "." + entityClass.getSimpleName();
        }

        public Update of(Object object) {
            return new Update(this, object);
        }
    }
}

