/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data;

import org.granite.client.messaging.messages.responses.FaultMessage;
import org.granite.client.tide.Context;
import org.granite.client.tide.server.ExceptionHandler;
import org.granite.client.tide.server.TideFaultEvent;
import org.granite.logging.Logger;

public class OptimisticLockExceptionHandler
implements ExceptionHandler {
    private static Logger log = Logger.getLogger((String)"org.granite.tide.data.OptimisticLockExceptionHandler");

    @Override
    public boolean accepts(FaultMessage emsg) {
        return emsg.getCode().equals((Object)FaultMessage.Code.OPTIMISTIC_LOCK);
    }

    @Override
    public void handle(Context context, FaultMessage emsg, TideFaultEvent faultEvent) {
        Object entity;
        log.debug("optimistic lock error received %s", new Object[]{emsg.toString()});
        String receivedSessionId = faultEvent.getServerSession().getSessionId() + "_error";
        Object v0 = entity = emsg.getExtended() != null && emsg.getExtended().get("entity") != null ? emsg.getExtended().get("entity") : null;
        if (entity != null) {
            context.getEntityManager().mergeExternalData(faultEvent.getServerSession(), entity, null, receivedSessionId, null, null);
        }
    }
}

