/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.granite.client.tide.Resettable;
import org.granite.client.tide.ViewScope;

public class DefaultViewScope
implements ViewScope {
    private Map<String, Object> instanceCache = new ConcurrentHashMap<String, Object>();
    private ViewScope.GlobalResetter resetter = null;
    private Map<String, ViewScope.BeanResetter> resettersMap = new ConcurrentHashMap<String, ViewScope.BeanResetter>();
    private String viewId = null;

    @Override
    public String getViewId() {
        return this.viewId;
    }

    @Override
    public void ensureViewId(String viewId) {
        if (viewId.equals(this.viewId)) {
            return;
        }
        this.reset();
        this.viewId = viewId;
    }

    @Override
    public Object get(String name) {
        return this.instanceCache.get(name);
    }

    @Override
    public void put(String name, Object instance) {
        this.instanceCache.put(name, instance);
    }

    @Override
    public Object remove(String name) {
        Object instance = this.instanceCache.remove(name);
        if (instance instanceof Resettable) {
            ((Resettable)instance).reset();
        }
        if (this.resettersMap.containsKey(name)) {
            this.resettersMap.get(name).reset(instance);
            this.resettersMap.remove(name);
        }
        if (this.resetter != null) {
            this.resetter.reset(name, instance);
        }
        return instance;
    }

    @Override
    public void reset(Class<?> type) {
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.instanceCache.entrySet()) {
            if (!type.isInstance(entry.getValue())) continue;
            names.add(entry.getKey());
        }
        for (String name : names) {
            this.remove(name);
        }
    }

    @Override
    public void reset() {
        for (Map.Entry<String, Object> entry : this.instanceCache.entrySet()) {
            if (entry.getValue() instanceof Resettable) {
                ((Resettable)entry.getValue()).reset();
            }
            if (this.resettersMap.containsKey(entry.getKey())) {
                this.resettersMap.get(entry.getKey()).reset(entry.getValue());
            }
            if (this.resetter == null) continue;
            this.resetter.reset(entry.getKey(), entry.getValue());
        }
        this.instanceCache.clear();
        this.resettersMap.clear();
        this.viewId = null;
    }

    @Override
    public void setResetter(ViewScope.GlobalResetter resetter) {
        this.resetter = resetter;
    }

    @Override
    public void addResetter(String name, ViewScope.BeanResetter resetter) {
        this.resettersMap.put(name, resetter);
    }
}

