/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.granite.client.messaging.events.Event;
import org.granite.client.messaging.events.IncomingMessageEvent;
import org.granite.client.messaging.events.ResultEvent;
import org.granite.client.messaging.messages.responses.ResultMessage;
import org.granite.client.tide.Context;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.impl.ChangeEntity;
import org.granite.client.tide.data.impl.ChangeEntityRef;
import org.granite.client.tide.data.spi.MergeContext;
import org.granite.client.tide.server.ComponentListener;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.TideMergeResponder;
import org.granite.client.tide.server.TideResponder;
import org.granite.client.tide.server.TideResultEvent;
import org.granite.logging.Logger;
import org.granite.tide.data.Change;
import org.granite.tide.data.ChangeRef;
import org.granite.tide.invocation.InvocationResult;

public class ResultHandler<T>
implements Runnable {
    private final ServerSession serverSession;
    private final Context sourceContext;
    private final String componentName;
    private final String operation;
    private final Event event;
    private final Object info;
    private final TideResponder<T> tideResponder;
    private final ComponentListener<T> componentListener;
    private boolean executed = false;
    private static final Logger log = Logger.getLogger(ResultHandler.class);

    public ResultHandler(ServerSession serverSession, String componentName, String operation) {
        this.serverSession = serverSession;
        this.sourceContext = null;
        this.componentName = componentName;
        this.operation = operation;
        this.event = null;
        this.info = null;
        this.tideResponder = null;
        this.componentListener = null;
    }

    public ResultHandler(ServerSession serverSession, Event event) {
        this.serverSession = serverSession;
        this.sourceContext = null;
        this.componentName = null;
        this.operation = null;
        this.event = event;
        this.info = null;
        this.tideResponder = null;
        this.componentListener = null;
    }

    public ResultHandler(ServerSession serverSession, Context sourceContext, String componentName, String operation, Event event, Object info, TideResponder<T> tideResponder, ComponentListener<T> componentListener) {
        this.serverSession = serverSession;
        this.sourceContext = sourceContext;
        this.componentName = componentName;
        this.operation = operation;
        this.event = event;
        this.info = info;
        this.tideResponder = tideResponder;
        this.componentListener = componentListener;
    }

    @Override
    public void run() {
        if (this.executed) {
            return;
        }
        this.executed = true;
        InvocationResult invocationResult = null;
        Object result = null;
        if (this.event instanceof ResultEvent) {
            result = ((ResultEvent)this.event).getResult();
        } else if (this.event instanceof IncomingMessageEvent) {
            result = ((IncomingMessageEvent)this.event).getMessage();
        }
        if (result instanceof InvocationResult) {
            invocationResult = (InvocationResult)result;
            result = invocationResult.getResult();
        }
        if (this.tideResponder != null) {
            for (Type type : this.tideResponder.getClass().getGenericInterfaces()) {
                if (!(type instanceof ParameterizedType) || !((ParameterizedType)type).getRawType().equals(TideResponder.class)) continue;
                Type expectedReturnType = ((ParameterizedType)type).getActualTypeArguments()[0];
                result = this.serverSession.convert(result, expectedReturnType);
                if (invocationResult == null) break;
                invocationResult.setResult(result);
                break;
            }
        }
        Context context = this.sourceContext.getContextManager().retrieveContext(this.sourceContext, null, false, false);
        this.serverSession.onResultEvent(this.event);
        boolean handled = this.handleResult(context, invocationResult, result);
        if (invocationResult != null) {
            result = invocationResult.getResult();
        }
        this.componentListener.setResult(result);
        if (!handled && !this.serverSession.isLogoutInProgress()) {
            context.getEventBus().raiseEvent(context, "org.granite.tide.result", this.event instanceof ResultEvent ? (ResultMessage)((ResultEvent)this.event).getMessage() : null);
        }
        this.serverSession.tryLogout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleResult(Context context, InvocationResult invocationResult, Object result) {
        log.debug("result %s", new Object[]{result});
        ArrayList<EntityManager.Update> updates = null;
        EntityManager entityManager = context.getEntityManager();
        try {
            context.remove("flash");
            MergeContext mergeContext = entityManager.initMerge(this.serverSession);
            boolean mergeExternal = true;
            if (invocationResult != null) {
                mergeExternal = invocationResult.getMerge();
                if (invocationResult.getUpdates() != null && invocationResult.getUpdates().length > 0) {
                    updates = new ArrayList<EntityManager.Update>(invocationResult.getUpdates().length);
                    for (Object[] update : invocationResult.getUpdates()) {
                        String updateType = update[0].toString().toUpperCase();
                        Object entity = update[1];
                        if (EntityManager.UpdateKind.REFRESH.toString().toLowerCase().equals(updateType) && entity instanceof String) {
                            entity = this.serverSession.getAliasRegistry().getAliasForType((String)entity);
                        } else if (entity instanceof Change) {
                            entity = new ChangeEntity((Change)entity, this.serverSession.getAliasRegistry());
                        } else if (entity instanceof ChangeRef) {
                            entity = new ChangeEntityRef(entity, this.serverSession.getAliasRegistry());
                        }
                        updates.add(EntityManager.Update.forUpdate(updateType, entity));
                    }
                    entityManager.handleUpdates(mergeContext, null, updates);
                }
            }
            if (result != null) {
                if (mergeExternal) {
                    Object mergeWith = this.tideResponder instanceof TideMergeResponder ? ((TideMergeResponder)this.tideResponder).getMergeResultWith() : null;
                    result = entityManager.mergeExternal(mergeContext, result, mergeWith, null, null, false);
                } else {
                    log.debug("skipped merge of remote result", new Object[0]);
                }
                if (invocationResult != null) {
                    invocationResult.setResult(result);
                }
            }
        }
        finally {
            MergeContext.destroy(entityManager);
        }
        if (invocationResult != null && updates != null) {
            entityManager.raiseUpdateEvents(context, updates);
        }
        log.debug("result merged into local context", new Object[0]);
        if (invocationResult != null) {
            result = invocationResult.getResult();
        }
        boolean handled = false;
        if (this.tideResponder != null) {
            TideResultEvent<Object> resultEvent = new TideResultEvent<Object>(context, this.serverSession, this.componentListener, result);
            this.tideResponder.result(resultEvent);
            if (resultEvent.isDefaultPrevented()) {
                handled = true;
            }
        }
        return handled;
    }
}

