/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.client.configuration.ClassScanner;
import org.granite.client.platform.Platform;
import org.granite.client.tide.Application;
import org.granite.client.tide.Context;
import org.granite.client.tide.ContextManager;
import org.granite.client.tide.EventBus;
import org.granite.client.tide.Factory;
import org.granite.client.tide.InstanceStore;
import org.granite.client.tide.InstanceStoreFactory;
import org.granite.client.tide.Module;
import org.granite.client.tide.impl.DefaultApplication;
import org.granite.client.tide.impl.InstanceFactory;
import org.granite.client.tide.impl.SimpleEventBus;
import org.granite.client.tide.impl.SimpleInjectInstanceStore;
import org.granite.client.tide.impl.SimpleInstanceStore;
import org.granite.util.TypeUtil;

public class SimpleContextManager
implements ContextManager {
    static final String DEFAULT_CONTEXT = "__DEFAULT__CONTEXT__";
    public static final String CONTEXT_CREATE = "org.granite.tide.contextCreate";
    public static final String CONTEXT_DESTROY = "org.granite.tide.contextDestroy";
    protected final Application application;
    protected final EventBus eventBus;
    private InstanceStoreFactory instanceStoreFactory = new DefaultInstanceStoreFactory();
    private InstanceFactory instanceFactory = new InstanceFactory();
    private Map<String, Context> contextsById = new HashMap<String, Context>();
    private List<String> contextsToDestroy = new ArrayList<String>();

    public SimpleContextManager() {
        this.application = new DefaultApplication();
        this.eventBus = new SimpleEventBus();
    }

    public SimpleContextManager(Application application) {
        this.application = application;
        this.eventBus = new SimpleEventBus();
    }

    public SimpleContextManager(Application application, EventBus eventBus) {
        this.application = application;
        this.eventBus = eventBus;
    }

    public void setInstanceStoreFactory(InstanceStoreFactory instanceStoreFactory) {
        this.instanceStoreFactory = instanceStoreFactory;
    }

    @Override
    public boolean isGlobal(Context context) {
        return this.contextsById.get(DEFAULT_CONTEXT) == context;
    }

    @Override
    public Context getContext() {
        return this.getContext(null, null, true);
    }

    @Override
    public Context getContext(String contextId) {
        return this.getContext(contextId, null, true);
    }

    protected Context createContext(Context parentCtx, String contextId) {
        Context ctx = new Context(this, parentCtx, contextId);
        InstanceStore instanceStore = this.instanceStoreFactory.createStore(ctx, this.instanceFactory);
        ctx.initContext(this.application, this.eventBus, instanceStore);
        return ctx;
    }

    @Override
    public Context getContext(String contextId, String parentContextId, boolean create) {
        Context ctx = this.contextsById.get(contextId != null ? contextId : DEFAULT_CONTEXT);
        if (ctx == null && create) {
            Context parentCtx = this.contextsById.get(parentContextId == null ? DEFAULT_CONTEXT : parentContextId);
            if (parentContextId != null && parentCtx == null) {
                throw new IllegalStateException("Parent context not found for id " + parentContextId);
            }
            ctx = this.createContext(parentCtx, contextId);
            this.contextsById.put(contextId != null ? contextId : DEFAULT_CONTEXT, ctx);
            this.instanceFactory.initContext(ctx);
            if (contextId != null) {
                ctx.getEventBus().raiseEvent(ctx, CONTEXT_CREATE, new Object[0]);
            }
            ctx.postInit();
        }
        return ctx;
    }

    @Override
    public Context newContext(String contextId, String parentContextId) {
        Context ctx = this.contextsById.get(contextId != null ? contextId : DEFAULT_CONTEXT);
        if (ctx != null && ctx.isFinished()) {
            ctx.clear();
            this.contextsById.remove(contextId);
            this.removeFromContextsToDestroy(contextId);
            ctx = null;
        }
        if (ctx == null) {
            Context parentCtx = this.contextsById.get(parentContextId != null ? parentContextId : DEFAULT_CONTEXT);
            ctx = this.createContext(parentCtx, contextId);
            if (contextId != null) {
                this.contextsById.put(contextId, ctx);
            }
            ctx.getEventBus().raiseEvent(ctx, CONTEXT_CREATE, new Object[0]);
            ctx.postInit();
        }
        return ctx;
    }

    @Override
    public void destroyContext(String contextId) {
        Context ctx;
        Context context = ctx = contextId != null ? this.contextsById.get(contextId) : null;
        if (ctx != null) {
            for (Context c : this.contextsById.values()) {
                if (c.getParentContext() != ctx) continue;
                this.destroyContext(c.getContextId());
            }
            this.removeFromContextsToDestroy(contextId);
            ctx.getEventBus().raiseEvent(ctx, CONTEXT_DESTROY, new Object[0]);
            this.contextsById.get(contextId).clear();
            this.contextsById.remove(contextId);
        }
    }

    @Override
    public List<Context> getAllContexts() {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (Map.Entry<String, Context> ectx : this.contextsById.entrySet()) {
            if (ectx.getKey().equals(DEFAULT_CONTEXT)) continue;
            contexts.add(ectx.getValue());
        }
        return contexts;
    }

    @Override
    public void destroyContexts() {
        this.contextsToDestroy.clear();
        Context globalCtx = this.contextsById.get(DEFAULT_CONTEXT);
        ArrayList<String> contextIdsToDestroy = new ArrayList<String>();
        for (Map.Entry<String, Context> ectx : this.contextsById.entrySet()) {
            if (ectx.getKey().equals(DEFAULT_CONTEXT) || ectx.getValue().getParentContext() != globalCtx) continue;
            contextIdsToDestroy.add(ectx.getKey());
        }
        for (String contextId : contextIdsToDestroy) {
            this.destroyContext(contextId);
        }
        globalCtx.clear();
    }

    @Override
    public void destroyFinishedContexts() {
        for (String contextId : this.contextsToDestroy) {
            this.destroyContext(contextId);
        }
        this.contextsToDestroy.clear();
    }

    @Override
    public void removeFromContextsToDestroy(String contextId) {
        int idx = this.contextsToDestroy.indexOf(contextId);
        if (idx >= 0) {
            this.contextsToDestroy.remove(idx);
        }
    }

    @Override
    public void addToContextsToDestroy(String contextId) {
        if (this.contextsToDestroy.contains(contextId)) {
            return;
        }
        this.contextsToDestroy.add(contextId);
    }

    @Override
    public Context retrieveContext(Context sourceContext, String contextId, boolean wasConversationCreated, boolean wasConversationEnded) {
        Context context = null;
        if (!this.isGlobal(sourceContext) && contextId == null && wasConversationEnded) {
            context = sourceContext;
            context.markAsFinished();
        } else if (!this.isGlobal(sourceContext) && contextId == null && !sourceContext.isContextIdFromServer()) {
            context = sourceContext;
        } else if (!(this.isGlobal(sourceContext) || contextId == null || sourceContext.getContextId() != null && (sourceContext.getContextId().equals(contextId) || wasConversationCreated))) {
            String previousContextId = sourceContext.getContextId();
            context = sourceContext;
            context.setContextId(contextId, true);
            this.updateContextId(previousContextId, context);
        } else {
            context = this.getContext(contextId);
            if (contextId != null) {
                context.setContextId(contextId, true);
            }
        }
        return context;
    }

    @Override
    public void updateContextId(String previousContextId, Context context) {
        if (previousContextId != null) {
            this.contextsById.remove(previousContextId);
        }
        this.contextsById.put(context.getContextId(), context);
    }

    public void scanModules(String ... packageNames) {
        ClassScanner classScanner = Platform.getInstance().newClassScanner();
        Set moduleClasses = classScanner.scan(new HashSet<String>(Arrays.asList(packageNames)), Module.class);
        this.instanceFactory.initModules(moduleClasses);
    }

    public void initModules(String ... moduleClassNames) {
        HashSet moduleClasses = new HashSet();
        for (String className : moduleClassNames) {
            try {
                Class<?> c = Class.forName(className);
                moduleClasses.add(c);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not init module " + className);
            }
        }
        this.instanceFactory.initModules(moduleClasses);
    }

    public void initModules(Class<?> ... moduleClasses) {
        this.instanceFactory.initModules(new HashSet(Arrays.asList(moduleClasses)));
    }

    public void registerFactory(String name, Factory<?> factory) {
        this.instanceFactory.registerFactory(name, factory);
    }

    public void registerFactory(Class<?> type, Factory<?> factory) {
        this.instanceFactory.registerFactory(type, factory);
    }

    public static class DefaultInstanceStoreFactory
    implements InstanceStoreFactory {
        @Override
        public InstanceStore createStore(Context context, InstanceFactory instanceFactory) {
            try {
                TypeUtil.forName((String)"javax.inject.Inject");
                return new SimpleInjectInstanceStore(context, instanceFactory);
            }
            catch (ClassNotFoundException e) {
                return new SimpleInstanceStore(context, instanceFactory);
            }
        }
    }
}

