/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.granite.client.tide.Context;
import org.granite.client.tide.impl.InstanceFactory;
import org.granite.client.tide.impl.SimpleInstanceStore;

public class SimpleInjectInstanceStore
extends SimpleInstanceStore {
    public SimpleInjectInstanceStore(Context context, InstanceFactory instanceFactory) {
        super(context, instanceFactory);
    }

    @Override
    public void inject(Object target, String componentName, Map<String, Object> properties) {
        Object value;
        if (target == null) {
            throw new IllegalArgumentException("Cannot inject null object");
        }
        for (Class<?> c = target.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (!f.isAnnotationPresent(Inject.class)) continue;
                f.setAccessible(true);
                if (f.isAnnotationPresent(Named.class)) {
                    String name = f.getAnnotation(Named.class).value();
                    if ("".equals(name)) {
                        name = f.getName();
                    }
                    try {
                        Object value2 = this.context.byName(name);
                        if (value2 == null) continue;
                        f.set(target, value2);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot inject field " + f.getName() + " in component " + componentName, e);
                    }
                }
                try {
                    if (f.getType().isArray()) {
                        ?[] values = this.context.allByType(f.getType().getComponentType());
                        if (values == null) continue;
                        f.set(target, values);
                        continue;
                    }
                    value = this.context.byType(f.getType());
                    if (value == null) continue;
                    f.set(target, value);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot inject field " + f.getName() + " in component " + componentName, e);
                }
            }
        }
        if (componentName == null) {
            return;
        }
        for (String key : properties.keySet()) {
            int idx = key.indexOf(".");
            if (idx < 0 || !componentName.equals(key.substring(0, idx))) continue;
            String propertyName = key.substring(idx + 1);
            value = properties.get(key);
            String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            Method setter = null;
            for (Method s : target.getClass().getMethods()) {
                if (!s.getName().equals(setterName)) continue;
                setter = s;
                break;
            }
            if (setter == null) {
                throw new RuntimeException("No setter found for " + key);
            }
            try {
                setter.invoke(target, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set value for bundle property " + key);
            }
        }
    }
}

