/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.granite.client.tide.BaseIdentity;
import org.granite.client.tide.server.TideFaultEvent;
import org.granite.client.tide.server.TideResponder;
import org.granite.client.tide.server.TideResultEvent;

public class TidePermissionCache {
    private final BaseIdentity identity;
    private final Map<Object, Map<String, Object>> cache = new IdentityHashMap<Object, Map<String, Object>>();

    public TidePermissionCache(BaseIdentity identity) {
        this.identity = identity;
    }

    public boolean get(Object object, String action, TideResponder<Boolean> tideResponder) {
        Object cached;
        Map<String, Object> objectCache = this.cache.get(object);
        if (objectCache == null) {
            objectCache = new HashMap<String, Object>();
            this.cache.put(object, objectCache);
        }
        if ((cached = objectCache.get(action)) == null) {
            if (this.identity.isLoggedIn()) {
                TidePermissionResponder responder = new TidePermissionResponder(object, action, tideResponder);
                this.identity.call("hasPermission", object, action, responder);
                objectCache.put(action, responder);
            }
            return false;
        }
        if (cached instanceof TideResponder) {
            ((TidePermissionResponder)cached).addResponder(tideResponder);
            return false;
        }
        if (tideResponder != null) {
            TideResultEvent<Boolean> event = this.identity.newResultEvent((Boolean)cached);
            tideResponder.result(event);
        }
        return (Boolean)cached;
    }

    public void clear() {
        for (Map.Entry<Object, Map<String, Object>> me : this.cache.entrySet()) {
            for (Map.Entry<String, Object> me2 : me.getValue().entrySet()) {
                if (me2.getValue() != Boolean.TRUE) continue;
                this.identity.firePropertyChange("hasPermission", true, false);
            }
        }
        this.cache.clear();
    }

    private class TidePermissionResponder
    implements TideResponder<Boolean> {
        private final Object object;
        private final String action;
        private final List<TideResponder<Boolean>> responders = new ArrayList<TideResponder<Boolean>>();

        public TidePermissionResponder(Object object, String action, TideResponder<Boolean> tideResponder) {
            this.object = object;
            this.action = action;
            if (tideResponder != null) {
                this.responders.add(tideResponder);
            }
        }

        public void addResponder(TideResponder<Boolean> tideResponder) {
            this.responders.add(tideResponder);
        }

        @Override
        public void result(TideResultEvent<Boolean> event) {
            boolean newValue;
            for (TideResponder<Boolean> responder : this.responders) {
                responder.result(event);
            }
            Map objectCache = (Map)TidePermissionCache.this.cache.get(this.object);
            Object cached = objectCache != null ? objectCache.get(this.action) : null;
            boolean oldValue = cached instanceof Boolean ? (Boolean)cached : false;
            objectCache.put(this.action, event.getResult());
            boolean bl = newValue = event.getResult() != null ? event.getResult() : false;
            if (event.getResult() != oldValue) {
                TidePermissionCache.this.identity.firePropertyChange("hasPermission", oldValue, newValue);
            }
        }

        @Override
        public void fault(TideFaultEvent event) {
            Map objectCache = (Map)TidePermissionCache.this.cache.get(this.object);
            if (objectCache != null) {
                objectCache.remove(this.action);
            }
            for (TideResponder<Boolean> responder : this.responders) {
                responder.fault(event);
            }
        }
    }
}

