/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.granite.client.tide.BaseIdentity;
import org.granite.client.tide.server.TideFaultEvent;
import org.granite.client.tide.server.TideResponder;
import org.granite.client.tide.server.TideResultEvent;

public class TideRoleCache {
    private final BaseIdentity identity;
    private final String type;
    private final Map<String, Object> cache = new HashMap<String, Object>();

    public TideRoleCache(BaseIdentity identity, String type) {
        this.identity = identity;
        this.type = type;
    }

    public boolean get(String roleName, TideResponder<Boolean> tideResponder) {
        Object cached = this.cache.get(roleName);
        if (cached == null) {
            if (this.identity.isLoggedIn()) {
                TideRoleResponder responder = new TideRoleResponder(roleName, tideResponder);
                this.identity.call(this.type, roleName, responder);
                this.cache.put(roleName, responder);
            }
            return false;
        }
        if (cached instanceof TideResponder) {
            ((TideRoleResponder)cached).addResponder(tideResponder);
            return false;
        }
        if (tideResponder != null) {
            TideResultEvent<Boolean> event = this.identity.newResultEvent((Boolean)cached);
            tideResponder.result(event);
        }
        return (Boolean)cached;
    }

    public void clear() {
        for (Map.Entry<String, Object> me : this.cache.entrySet()) {
            if (me.getValue() != Boolean.TRUE) continue;
            this.identity.firePropertyChange(this.type, true, false);
        }
        this.cache.clear();
    }

    private class TideRoleResponder
    implements TideResponder<Boolean> {
        private final String roleName;
        private final List<TideResponder<Boolean>> responders = new ArrayList<TideResponder<Boolean>>();

        public TideRoleResponder(String roleName, TideResponder<Boolean> tideResponder) {
            this.roleName = roleName;
            if (tideResponder != null) {
                this.responders.add(tideResponder);
            }
        }

        public void addResponder(TideResponder<Boolean> tideResponder) {
            this.responders.add(tideResponder);
        }

        @Override
        public void result(TideResultEvent<Boolean> event) {
            boolean newValue;
            for (TideResponder<Boolean> responder : this.responders) {
                responder.result(event);
            }
            Object cached = TideRoleCache.this.cache.get(this.roleName);
            boolean oldValue = cached instanceof Boolean ? (Boolean)cached : false;
            TideRoleCache.this.cache.put(this.roleName, event.getResult());
            boolean bl = newValue = event.getResult() != null ? event.getResult() : false;
            if (event.getResult() != oldValue) {
                TideRoleCache.this.identity.firePropertyChange(TideRoleCache.this.type, oldValue, newValue);
            }
        }

        @Override
        public void fault(TideFaultEvent event) {
            TideRoleCache.this.cache.remove(this.roleName);
            for (TideResponder<Boolean> responder : this.responders) {
                responder.fault(event);
            }
        }
    }
}

