/*
 * Decompiled with CFR 0.152.
 */
package org.granite.seam;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.DefaultServiceExceptionHandler;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.service.security.SecurityServiceException;
import org.hibernate.validator.InvalidStateException;
import org.hibernate.validator.InvalidValue;

public class SeamServiceExceptionHandler
extends DefaultServiceExceptionHandler {
    private static final long serialVersionUID = -929771583032427716L;
    private static final Logger log = Logger.getLogger(SeamServiceExceptionHandler.class);

    public SeamServiceExceptionHandler() {
        this(true);
    }

    public SeamServiceExceptionHandler(boolean logException) {
        super(logException);
    }

    public ServiceException handleInvocationException(ServiceInvocationContext context, Throwable t) {
        try {
            InvalidStateException ise;
            InvalidValue[] temp;
            while (!(t instanceof InvalidStateException) && t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof InvalidStateException && (temp = (ise = (InvalidStateException)t).getInvalidValues()) != null && temp.length > 0) {
                for (int i = 0; i < temp.length; ++i) {
                    FacesContext.getCurrentInstance().addMessage(temp[i].getPropertyName(), new FacesMessage(temp[i].getMessage()));
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Could not add FacesMessage for exception: %s", new Object[]{t});
        }
        if (t instanceof SecurityServiceException) {
            log.debug(t, "Could not process remoting message: %s", new Object[]{context.getMessage()});
        } else {
            log.error(t, "Could not process remoting message: %s", new Object[]{context.getMessage()});
        }
        return this.getServiceException(context, t);
    }
}

