/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam;

import flex.messaging.messages.RemotingMessage;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.data.PersistenceExceptionConverter;
import org.granite.tide.seam.SeamServiceInvoker;
import org.granite.util.XMap;
import org.jboss.seam.Component;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamServiceFactory
extends ServiceFactory {
    private static final Log log = Logging.getLog(SeamServiceFactory.class);
    private Component contextComponent = null;

    public void configure(XMap properties) throws ServiceException {
        String sServiceExceptionHandler = properties.get("service-exception-handler");
        if (sServiceExceptionHandler == null) {
            XMap props = new XMap(properties);
            if (Component.forName((String)"org.jboss.seam.international.statusMessages") != null) {
                props.put("service-exception-handler", "org.granite.tide.seam21.Seam21ServiceExceptionHandler");
            } else {
                props.put("service-exception-handler", "org.granite.tide.seam.SeamServiceExceptionHandler");
            }
            super.configure(props);
        } else {
            super.configure(properties);
        }
        GraniteContext graniteContext = GraniteContext.getCurrentInstance();
        try {
            graniteContext.getGraniteConfig().registerExceptionConverter(PersistenceExceptionConverter.class);
        }
        catch (Throwable t) {
            log.info((Object)t, new Object[]{"JPA exception converter not registered (JPA not found on classpath)"});
        }
        this.contextComponent = Component.forName((String)"org.granite.tide.seam.serviceContext");
        if (this.contextComponent == null) {
            String msg = "Unable to find the SeamServiceContext component";
            log.error((Object)msg, new Object[0]);
            ServiceException e = new ServiceException(msg);
            throw e;
        }
    }

    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        Destination destination = context.getServicesConfig().findDestinationById(messageType, destinationId);
        if (destination == null) {
            throw new ServiceException("No matching destination: " + destinationId);
        }
        SeamServiceInvoker invoker = new SeamServiceInvoker(destination, this);
        return invoker;
    }
}

