/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam;

import org.granite.gravity.Gravity;
import org.granite.tide.data.DataContext;
import org.granite.tide.data.DataEnabled;
import org.granite.tide.data.DataUpdatePostprocessor;
import org.granite.tide.seam.SeamUtils;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.core.Events;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.transaction.TransactionInterceptor;

@Interceptor(stateless=true, within={TransactionInterceptor.class})
public class TideDataPublishingInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocationContext) throws Exception {
        DataEnabled dataEnabled = this.getComponent().getBeanClass().getAnnotation(DataEnabled.class);
        if (dataEnabled == null || !dataEnabled.useInterceptor()) {
            return invocationContext.proceed();
        }
        if (SeamUtils.isLifecycleMethod(this.getComponent(), invocationContext.getMethod())) {
            return invocationContext.proceed();
        }
        boolean shouldRemoveContextAtEnd = DataContext.get() == null;
        boolean shouldInitContext = shouldRemoveContextAtEnd || DataContext.isNull();
        boolean onCommit = false;
        if (shouldInitContext) {
            Gravity gravity = (Gravity)Component.getInstance((String)"org.granite.seam.gravity");
            DataContext.init((Gravity)gravity, (String)dataEnabled.topic(), (Class)dataEnabled.params(), (DataEnabled.PublishMode)dataEnabled.publish());
            DataUpdatePostprocessor dataUpdatePostprocessor = (DataUpdatePostprocessor)Component.getInstance((String)"org.granite.tide.seam.data.dataUpdatePreprocessor", (boolean)true);
            if (dataUpdatePostprocessor != null) {
                DataContext.get().setDataUpdatePostprocessor(dataUpdatePostprocessor);
            }
        }
        DataContext.observe();
        try {
            if (dataEnabled.publish().equals((Object)DataEnabled.PublishMode.ON_COMMIT)) {
                Events.instance().raiseTransactionSuccessEvent("org.granite.tide.seam.data.transactionSuccess", new Object[]{shouldRemoveContextAtEnd});
                Events.instance().raiseTransactionCompletionEvent("org.granite.tide.seam.data.transactionCompletion", new Object[]{shouldRemoveContextAtEnd});
                onCommit = true;
            }
            Object ret = invocationContext.proceed();
            DataContext.publish((DataEnabled.PublishMode)DataEnabled.PublishMode.ON_SUCCESS);
            Object object = ret;
            return object;
        }
        finally {
            if (shouldRemoveContextAtEnd && !onCommit) {
                DataContext.remove();
            }
        }
    }

    public boolean isInterceptorEnabled() {
        return this.getComponent().beanClassHasAnnotation(DataEnabled.class) && this.getComponent().getBeanClass().getAnnotation(DataEnabled.class).useInterceptor();
    }
}

