/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.HelpCommand;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.commandline.arguments.Arguments;

class HelpCommandTest {
    @Mock
    private Consumer<String> out;

    HelpCommandTest() {
    }

    @BeforeEach
    void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    void printsUnknownCommandWhenUnknownCommandIsProvided() {
        CommandLocator commandLocator = (CommandLocator)Mockito.mock(CommandLocator.class);
        Mockito.when((Object)commandLocator.getAllProviders()).thenReturn(Collections.emptyList());
        Mockito.when((Object)commandLocator.findProvider("foobar")).thenThrow(new Throwable[]{new NoSuchElementException("foobar")});
        HelpCommand helpCommand = new HelpCommand((Usage)Mockito.mock(Usage.class), this.out, commandLocator);
        IncorrectUsage incorrectUsage = (IncorrectUsage)Assertions.assertThrows(IncorrectUsage.class, () -> helpCommand.execute(new String[]{"foobar"}));
        MatcherAssert.assertThat((Object)incorrectUsage.getMessage(), (Matcher)CoreMatchers.containsString((String)"Unknown command: foobar"));
    }

    @Test
    void printsAvailableCommandsWhenUnknownCommandIsProvided() {
        CommandLocator commandLocator = (CommandLocator)Mockito.mock(CommandLocator.class);
        List<AdminCommand.Provider> mockCommands = Arrays.asList(HelpCommandTest.mockCommand("foo"), HelpCommandTest.mockCommand("bar"), HelpCommandTest.mockCommand("baz"));
        Mockito.when((Object)commandLocator.getAllProviders()).thenReturn(mockCommands);
        Mockito.when((Object)commandLocator.findProvider("foobar")).thenThrow(new Throwable[]{new NoSuchElementException("foobar")});
        HelpCommand helpCommand = new HelpCommand((Usage)Mockito.mock(Usage.class), this.out, commandLocator);
        IncorrectUsage incorrectUsage = (IncorrectUsage)Assertions.assertThrows(IncorrectUsage.class, () -> helpCommand.execute(new String[]{"foobar"}));
        MatcherAssert.assertThat((Object)incorrectUsage.getMessage(), (Matcher)CoreMatchers.containsString((String)"Available commands are: foo bar baz"));
    }

    @Test
    void testAdminUsage() throws Exception {
        CommandLocator commandLocator = (CommandLocator)Mockito.mock(CommandLocator.class);
        List<AdminCommand.Provider> mockCommands = Arrays.asList(HelpCommandTest.mockCommand("foo"), HelpCommandTest.mockCommand("bar"), HelpCommandTest.mockCommand("baz"));
        Mockito.when((Object)commandLocator.getAllProviders()).thenReturn(mockCommands);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", commandLocator);
            HelpCommand helpCommand = new HelpCommand(usage, ps::println, commandLocator);
            helpCommand.execute(new String[0]);
            Assertions.assertEquals((Object)String.format("usage: neo4j-admin <command>%n%nManage your Neo4j instance.%n%nenvironment variables:%n    NEO4J_CONF    Path to directory which contains neo4j.conf.%n    NEO4J_DEBUG   Set to anything to enable debug output.%n    NEO4J_HOME    Neo4j home directory.%n    HEAP_SIZE     Set JVM maximum heap size during command execution.%n                  Takes a number and a unit, for example 512m.%n%navailable commands:%n%nGeneral%n    bar%n        null%n    baz%n        null%n    foo%n        null%n%nUse neo4j-admin help <command> for more details.%n", new Object[0]), (Object)baos.toString());
        }
    }

    @Test
    void showsArgumentsAndDescriptionForSpecifiedCommand() throws Exception {
        CommandLocator commandLocator = (CommandLocator)Mockito.mock(CommandLocator.class);
        AdminCommand.Provider commandProvider = (AdminCommand.Provider)Mockito.mock(AdminCommand.Provider.class);
        Mockito.when((Object)commandProvider.name()).thenReturn((Object)"foobar");
        Arguments arguments = new Arguments().withDatabase();
        Mockito.when((Object)commandProvider.allArguments()).thenReturn((Object)arguments);
        Mockito.when((Object)commandProvider.possibleArguments()).thenReturn(Collections.singletonList(arguments));
        Mockito.when((Object)commandProvider.description()).thenReturn((Object)"This is a description of the foobar command.");
        Mockito.when((Object)commandLocator.findProvider("foobar")).thenReturn((Object)commandProvider);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            HelpCommand helpCommand = new HelpCommand(new Usage("neo4j-admin", commandLocator), ps::println, commandLocator);
            helpCommand.execute(new String[]{"foobar"});
            Assertions.assertEquals((Object)String.format("usage: neo4j-admin foobar [--database=<name>]%n%nenvironment variables:%n    NEO4J_CONF    Path to directory which contains neo4j.conf.%n    NEO4J_DEBUG   Set to anything to enable debug output.%n    NEO4J_HOME    Neo4j home directory.%n    HEAP_SIZE     Set JVM maximum heap size during command execution.%n                  Takes a number and a unit, for example 512m.%n%nThis is a description of the foobar command.%n%noptions:%n  --database=<name>   Name of database. [default:graph.db]%n", new Object[0]), (Object)baos.toString());
        }
    }

    private static AdminCommand.Provider mockCommand(String name) {
        AdminCommand.Provider commandProvider = (AdminCommand.Provider)Mockito.mock(AdminCommand.Provider.class);
        Mockito.when((Object)commandProvider.name()).thenReturn((Object)name);
        Mockito.when((Object)commandProvider.commandSection()).thenReturn((Object)AdminCommandSection.general());
        return commandProvider;
    }
}

