/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.arguments;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.MandatoryNamedArg;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalBooleanArg;

class ArgumentsTest {
    private Arguments builder;

    ArgumentsTest() {
    }

    @BeforeEach
    void setup() {
        this.builder = new Arguments();
    }

    @Test
    void throwsOnUnexpectedLongArgument() {
        IncorrectUsage incorrectUsage = (IncorrectUsage)Assertions.assertThrows(IncorrectUsage.class, () -> this.builder.withDatabase().parse(new String[]{"--stacktrace"}));
        Assertions.assertEquals((Object)"unrecognized option: 'stacktrace'", (Object)incorrectUsage.getMessage());
    }

    @Test
    void throwsOnUnexpectedLongArgumentWithValue() {
        IncorrectUsage incorrectUsage = (IncorrectUsage)Assertions.assertThrows(IncorrectUsage.class, () -> this.builder.withDatabase().parse(new String[]{"--stacktrace=true"}));
        Assertions.assertEquals((Object)"unrecognized option: 'stacktrace'", (Object)incorrectUsage.getMessage());
    }

    @Test
    void throwsOnUnexpectedShortArgument() {
        IncorrectUsage incorrectUsage = (IncorrectUsage)Assertions.assertThrows(IncorrectUsage.class, () -> this.builder.withDatabase().parse(new String[]{"-f"}));
        Assertions.assertEquals((Object)"unrecognized option: 'f'", (Object)incorrectUsage.getMessage());
    }

    @Test
    void throwsOnUnexpectedShortArgumentWithValue() {
        IncorrectUsage incorrectUsage = (IncorrectUsage)Assertions.assertThrows(IncorrectUsage.class, () -> this.builder.withDatabase().parse(new String[]{"-f=bob"}));
        Assertions.assertEquals((Object)"unrecognized option: 'f'", (Object)incorrectUsage.getMessage());
    }

    @Test
    void throwsOnUnexpectedPositionalArgument() {
        IncorrectUsage incorrectUsage = (IncorrectUsage)Assertions.assertThrows(IncorrectUsage.class, () -> this.builder.withDatabase().parse(new String[]{"bob", "sob"}));
        Assertions.assertEquals((Object)"unrecognized arguments: 'bob sob'", (Object)incorrectUsage.getMessage());
    }

    @Test
    void throwsOnUnexpectedPositionalArgumentWhenExpectingSome() {
        IncorrectUsage incorrectUsage = (IncorrectUsage)Assertions.assertThrows(IncorrectUsage.class, () -> this.builder.withMandatoryPositionalArgument(0, "first").withOptionalPositionalArgument(1, "second").parse(new String[]{"one", "two", "three", "four"}));
        Assertions.assertEquals((Object)"unrecognized arguments: 'three four'", (Object)incorrectUsage.getMessage());
    }

    @Test
    void throwsOnTooFewPositionalArguments() {
        IncorrectUsage incorrectUsage = (IncorrectUsage)Assertions.assertThrows(IncorrectUsage.class, () -> this.builder.withMandatoryPositionalArgument(0, "first").withOptionalPositionalArgument(1, "second").parse(new String[0]));
        Assertions.assertEquals((Object)"not enough arguments", (Object)incorrectUsage.getMessage());
    }

    @Test
    void argumentNoValue() throws Exception {
        Arguments args = this.builder.withArgument((NamedArgument)new OptionalBooleanArg("flag", false, "description"));
        args.parse(new String[]{"--flag"});
        Assertions.assertTrue((boolean)args.getBoolean("flag"));
        args.parse(new String[0]);
        Assertions.assertFalse((boolean)args.getBoolean("flag"));
    }

    @Test
    void argumentWithEquals() throws Exception {
        Arguments args = this.builder.withArgument((NamedArgument)new OptionalBooleanArg("flag", false, "description"));
        args.parse(new String[]{"--flag=true"});
        Assertions.assertTrue((boolean)args.getBoolean("flag"));
        args.parse(new String[]{"--flag=false"});
        Assertions.assertFalse((boolean)args.getBoolean("flag"));
    }

    @Test
    void argumentWithSpace() throws Exception {
        Arguments args = this.builder.withArgument((NamedArgument)new OptionalBooleanArg("flag", false, "description"));
        args.parse(new String[]{"--flag", "true"});
        Assertions.assertTrue((boolean)args.getBoolean("flag"));
        args.parse(new String[]{"--flag", "false"});
        Assertions.assertFalse((boolean)args.getBoolean("flag"));
    }

    @Test
    void withDatabaseUsage() {
        Assertions.assertEquals((Object)"[--database=<name>]", (Object)this.builder.withDatabase().usage());
    }

    @Test
    void withDatabaseDescription() {
        Assertions.assertEquals((Object)String.format("How to use%n%noptions:%n  --database=<name>   Name of database. [default:graph.db]", new Object[0]), (Object)this.builder.withDatabase().description("How to use"));
    }

    @Test
    void withDatabaseToUsage() {
        Assertions.assertEquals((Object)"[--database=<name>] --to=<destination-path>", (Object)this.builder.withDatabase().withTo("Destination file.").usage());
    }

    @Test
    void withDatabaseToDescription() {
        Assertions.assertEquals((Object)String.format("How to use%n%noptions:%n  --database=<name>         Name of database. [default:graph.db]%n  --to=<destination-path>   Destination file.", new Object[0]), (Object)this.builder.withDatabase().withTo("Destination file.").description("How to use"));
    }

    @Test
    void withDatabaseToMultilineDescription() {
        Assertions.assertEquals((Object)String.format("How to use%n%noptions:%n  --database=<name>         Name of database. [default:graph.db]%n  --to=<destination-path>   This is a long string which should wrap on right%n                            col.", new Object[0]), (Object)this.builder.withDatabase().withTo("This is a long string which should wrap on right col.").description("How to use"));
    }

    @Test
    void longNamesTriggerNewLineFormatting() {
        Assertions.assertEquals((Object)String.format("How to use%n%noptions:%n  --database=<name>%n      Name of database. [default:graph.db]%n  --to=<destination-path>%n      This is a long string which should not wrap on right col.%n  --loooooooooooooong-variable-name=<loooooooooooooong-variable-value>%n      This is also a long string which should be printed on a new line because%n      of long names.", new Object[0]), (Object)this.builder.withDatabase().withTo("This is a long string which should not wrap on right col.").withArgument((NamedArgument)new MandatoryNamedArg("loooooooooooooong-variable-name", "loooooooooooooong-variable-value", "This is also a long string which should be printed on a new line because of long names.")).description("How to use"));
    }

    @Test
    void descriptionShouldHandleExistingNewlines() {
        Assertions.assertEquals((Object)String.format("This is the first line%nAnd this is the second line%nThe third line is so long that it requires some wrapping by the code itself%nbecause as you can see it just keeps going ang going and going and going and%ngoing and going.", new Object[0]), (Object)this.builder.description(String.format("This is the first line%nAnd this is the second line%nThe third line is so long that it requires some wrapping by the code itself because as you can see it just keeps going ang going and going and going and going and going.", new Object[0])));
    }

    @Test
    void wrappingHandlesBothKindsOfLineEndingsAndOutputsPlatformDependentOnes() {
        Assertions.assertEquals((Object)String.format("One with Linux%nOne with Windows%nAnd one which is%njust long and should%nbe wrapped by the%nfunction", new Object[0]), (Object)Arguments.wrapText((String)"One with Linux\nOne with Windows\r\nAnd one which is just long and should be wrapped by the function", (int)20));
    }
}

