/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.consistency.CheckConsistencyCommand;
import org.neo4j.consistency.CheckConsistencyCommandProvider;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={TestDirectoryExtension.class})
class CheckConsistencyCommandTest {
    @Inject
    private TestDirectory testDir;

    CheckConsistencyCommandTest() {
    }

    @Test
    void runsConsistencyChecker() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        File databasesFolder = CheckConsistencyCommandTest.getDatabasesFolder(homeDir);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), consistencyCheckService);
        DatabaseLayout databaseLayout = DatabaseLayout.of((File)databasesFolder, (String)"mydb");
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.eq((Object)databaseLayout), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)false), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--database=mydb"});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.eq((Object)databaseLayout), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)false), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    void enablesVerbosity() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        File databasesFolder = CheckConsistencyCommandTest.getDatabasesFolder(homeDir);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), consistencyCheckService);
        DatabaseLayout databaseLayout = DatabaseLayout.of((File)databasesFolder, (String)"mydb");
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.eq((Object)databaseLayout), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)true), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--database=mydb", "--verbose"});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.eq((Object)databaseLayout), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)true), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    void failsWhenInconsistenciesAreFound() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        File databasesFolder = CheckConsistencyCommandTest.getDatabasesFolder(homeDir);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), consistencyCheckService);
        DatabaseLayout databaseLayout = DatabaseLayout.of((File)databasesFolder, (String)"mydb");
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.eq((Object)databaseLayout), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)true), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.failure((File)new File("/the/report/path")));
        CommandFailed commandFailed = (CommandFailed)Assertions.assertThrows(CommandFailed.class, () -> checkConsistencyCommand.execute(new String[]{"--database=mydb", "--verbose"}));
        MatcherAssert.assertThat((Object)commandFailed.getMessage(), (Matcher)CoreMatchers.containsString((String)new File("/the/report/path").toString()));
    }

    @Test
    void shouldWriteReportFileToCurrentDirectoryByDefault() throws IOException, ConsistencyCheckIncompleteException, CommandFailed, IncorrectUsage {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), consistencyCheckService);
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--database=mydb"});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.eq((Object)new File(".").getCanonicalFile()), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    void shouldWriteReportFileToSpecifiedDirectory() throws IOException, ConsistencyCheckIncompleteException, CommandFailed, IncorrectUsage {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), consistencyCheckService);
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--database=mydb", "--report-dir=some-dir-or-other"});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.eq((Object)new File("some-dir-or-other").getCanonicalFile()), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    void shouldCanonicalizeReportDirectory() throws IOException, ConsistencyCheckIncompleteException, CommandFailed, IncorrectUsage {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), consistencyCheckService);
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--database=mydb", "--report-dir=" + Paths.get("..", "bar")});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.eq((Object)new File("../bar").getCanonicalFile()), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    void passesOnCheckParameters() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), consistencyCheckService);
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--database=mydb", "--check-graph=false", "--check-indexes=false", "--check-index-structure=false", "--check-label-scan-store=false", "--check-property-owners=true"});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.eq((Object)new ConsistencyFlags(false, false, false, false, true)));
    }

    @Test
    void databaseAndBackupAreMutuallyExclusive() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), consistencyCheckService);
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        IncorrectUsage incorrectUsage = (IncorrectUsage)Assertions.assertThrows(IncorrectUsage.class, () -> checkConsistencyCommand.execute(new String[]{"--database=foo", "--backup=bar"}));
        Assertions.assertEquals((Object)"Only one of '--database' and '--backup' can be specified.", (Object)incorrectUsage.getMessage());
    }

    @Test
    void backupNeedsToBePath() {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), consistencyCheckService);
        File backupPath = new File(homeDir.toFile(), "dir/does/not/exist");
        CommandFailed commandFailed = (CommandFailed)Assertions.assertThrows(CommandFailed.class, () -> checkConsistencyCommand.execute(new String[]{"--backup=" + backupPath}));
        Assertions.assertEquals((Object)("Specified backup should be a directory: " + backupPath), (Object)commandFailed.getMessage());
    }

    @Test
    void canRunOnBackup() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        DatabaseLayout backupLayout = this.testDir.databaseLayout("backup");
        Path homeDir = this.testDir.directory("home").toPath();
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), consistencyCheckService);
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.eq((Object)backupLayout), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)false), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--backup=" + backupLayout.databaseDirectory()});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((DatabaseLayout)ArgumentMatchers.eq((Object)backupLayout), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)false), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    void shouldPrintNiceHelp() throws Throwable {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
            usage.printUsageForCommand((AdminCommand.Provider)new CheckConsistencyCommandProvider(), ps::println);
            Assertions.assertEquals((Object)String.format("usage: neo4j-admin check-consistency [--database=<name>]%n                                     [--backup=</path/to/backup>]%n                                     [--verbose[=<true|false>]]%n                                     [--report-dir=<directory>]%n                                     [--additional-config=<config-file-path>]%n                                     [--check-graph[=<true|false>]]%n                                     [--check-indexes[=<true|false>]]%n                                     [--check-index-structure[=<true|false>]]%n                                     [--check-label-scan-store[=<true|false>]]%n                                     [--check-property-owners[=<true|false>]]%n%nenvironment variables:%n    NEO4J_CONF    Path to directory which contains neo4j.conf.%n    NEO4J_DEBUG   Set to anything to enable debug output.%n    NEO4J_HOME    Neo4j home directory.%n    HEAP_SIZE     Set JVM maximum heap size during command execution.%n                  Takes a number and a unit, for example 512m.%n%nThis command allows for checking the consistency of a database or a backup%nthereof. It cannot be used with a database which is currently in use.%n%nAll checks except 'check-graph' can be quite expensive so it may be useful to%nturn them off for very large databases. Increasing the heap size can also be a%ngood idea. See 'neo4j-admin help' for details.%n%noptions:%n  --database=<name>                        Name of database. [default:graph.db]%n  --backup=</path/to/backup>               Path to backup to check consistency%n                                           of. Cannot be used together with%n                                           --database. [default:]%n  --verbose=<true|false>                   Enable verbose output.%n                                           [default:false]%n  --report-dir=<directory>                 Directory to write report file in.%n                                           [default:.]%n  --additional-config=<config-file-path>   Configuration file to supply%n                                           additional configuration in. This%n                                           argument is DEPRECATED. [default:]%n  --check-graph=<true|false>               Perform checks between nodes,%n                                           relationships, properties, types and%n                                           tokens. [default:true]%n  --check-indexes=<true|false>             Perform checks on indexes.%n                                           [default:true]%n  --check-index-structure=<true|false>     Perform structure checks on indexes.%n                                           [default:false]%n  --check-label-scan-store=<true|false>    Perform checks on the label scan%n                                           store. [default:true]%n  --check-property-owners=<true|false>     Perform additional checks on property%n                                           ownership. This check is *very*%n                                           expensive in time and memory.%n                                           [default:false]%n", new Object[0]), (Object)baos.toString());
        }
    }

    private static File getDatabasesFolder(Path homeDir) {
        return (File)Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (String)homeDir.toAbsolutePath().toString()).get(GraphDatabaseSettings.databases_root_path);
    }
}

