/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.NodeRecordCheck;
import org.neo4j.consistency.checking.PropertyChain;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsAllocator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class NodeRecordCheckTest
extends RecordCheckTestBase<NodeRecord, ConsistencyReport.NodeConsistencyReport, NodeRecordCheck> {
    NodeRecordCheckTest() {
        super(new NodeRecordCheck(new RecordField[]{NodeRecordCheck.RelationshipField.NEXT_REL, NodeRecordCheck.LabelsField.LABELS, new PropertyChain(from -> null)}), ConsistencyReport.NodeConsistencyReport.class, new int[0], new MultiPassStore[0]);
    }

    @Test
    void shouldNotReportAnythingForNodeNotInUse() {
        NodeRecord node = NodeRecordCheckTest.notInUse(new NodeRecord(42L, false, 0L, 0L));
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldNotReportAnythingForNodeThatDoesNotReferenceOtherRecords() {
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, -1L, -1L));
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldNotReportAnythingForNodeWithConsistentReferences() {
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, 7L, 11L));
        this.add(NodeRecordCheckTest.inUse(new RelationshipRecord(7L, 42L, 0L, 0)));
        this.add(NodeRecordCheckTest.inUse(new PropertyRecord(11L)));
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportRelationshipNotInUse() {
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, 7L, 11L));
        RelationshipRecord relationship = this.add(NodeRecordCheckTest.notInUse(new RelationshipRecord(7L, 0L, 0L, 0)));
        this.add(NodeRecordCheckTest.inUse(new PropertyRecord(11L)));
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).relationshipNotInUse(relationship);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportPropertyNotInUse() {
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, -1L, 11L));
        PropertyRecord property = this.add(NodeRecordCheckTest.notInUse(new PropertyRecord(11L)));
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).propertyNotInUse(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportPropertyNotFirstInChain() {
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, -1L, 11L));
        PropertyRecord property = this.add(NodeRecordCheckTest.inUse(new PropertyRecord(11L)));
        property.setPrevProp(6L);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).propertyNotFirstInChain(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportRelationshipForOtherNodes() {
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, 7L, -1L));
        RelationshipRecord relationship = this.add(NodeRecordCheckTest.inUse(new RelationshipRecord(7L, 1L, 2L, 0)));
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).relationshipForOtherNode(relationship);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportRelationshipNotFirstInSourceChain() {
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, 7L, -1L));
        RelationshipRecord relationship = this.add(NodeRecordCheckTest.inUse(new RelationshipRecord(7L, 42L, 0L, 0)));
        relationship.setFirstPrevRel(6L);
        relationship.setFirstInFirstChain(false);
        relationship.setSecondPrevRel(8L);
        relationship.setFirstInSecondChain(false);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).relationshipNotFirstInSourceChain(relationship);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportRelationshipNotFirstInTargetChain() {
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, 7L, -1L));
        RelationshipRecord relationship = this.add(NodeRecordCheckTest.inUse(new RelationshipRecord(7L, 0L, 42L, 0)));
        relationship.setFirstPrevRel(6L);
        relationship.setFirstInFirstChain(false);
        relationship.setSecondPrevRel(8L);
        relationship.setFirstInSecondChain(false);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).relationshipNotFirstInTargetChain(relationship);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportLoopRelationshipNotFirstInTargetAndSourceChains() {
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, 7L, -1L));
        RelationshipRecord relationship = this.add(NodeRecordCheckTest.inUse(new RelationshipRecord(7L, 42L, 42L, 0)));
        relationship.setFirstPrevRel(8L);
        relationship.setFirstInFirstChain(false);
        relationship.setSecondPrevRel(8L);
        relationship.setFirstInSecondChain(false);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).relationshipNotFirstInSourceChain(relationship);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).relationshipNotFirstInTargetChain(relationship);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportLabelNotInUse() {
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, -1L, -1L));
        new InlineNodeLabels(node).add(1L, null, null);
        LabelTokenRecord labelRecordNotInUse = NodeRecordCheckTest.notInUse(new LabelTokenRecord(1L));
        this.add(labelRecordNotInUse);
        this.add(node);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).labelNotInUse(labelRecordNotInUse);
    }

    @Test
    void shouldReportDynamicLabelsNotInUse() {
        long[] labelIds = this.createLabels(100);
        LabelTokenRecord labelRecordNotInUse = NodeRecordCheckTest.notInUse(new LabelTokenRecord((long)labelIds.length));
        this.add(labelRecordNotInUse);
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, -1L, -1L));
        this.add(node);
        DynamicRecord labelsRecord1 = NodeRecordCheckTest.inUse(NodeRecordCheckTest.array(new DynamicRecord(1L)));
        DynamicRecord labelsRecord2 = NodeRecordCheckTest.inUse(NodeRecordCheckTest.array(new DynamicRecord(2L)));
        List<DynamicRecord> labelRecords = Arrays.asList(labelsRecord1, labelsRecord2);
        labelIds[12] = labelIds.length;
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)labelIds, (DynamicRecordAllocator)new ReusableRecordsAllocator(52, labelRecords));
        NodeRecordCheckTest.assertDynamicRecordChain(labelsRecord1, labelsRecord2);
        node.setLabelField(DynamicNodeLabels.dynamicPointer(labelRecords), labelRecords);
        this.addNodeDynamicLabels(labelsRecord1);
        this.addNodeDynamicLabels(labelsRecord2);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).labelNotInUse(labelRecordNotInUse);
    }

    @Test
    void shouldReportDuplicateLabels() {
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, -1L, -1L));
        new InlineNodeLabels(node).put(new long[]{1L, 2L, 1L}, null, null);
        LabelTokenRecord label1 = NodeRecordCheckTest.inUse(new LabelTokenRecord(1L));
        LabelTokenRecord label2 = NodeRecordCheckTest.inUse(new LabelTokenRecord(2L));
        this.add(label1);
        this.add(label2);
        this.add(node);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).labelDuplicate(1L);
    }

    @Test
    void shouldReportDuplicateDynamicLabels() {
        long[] labelIds = this.createLabels(100);
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, -1L, -1L));
        this.add(node);
        DynamicRecord labelsRecord1 = NodeRecordCheckTest.inUse(NodeRecordCheckTest.array(new DynamicRecord(1L)));
        DynamicRecord labelsRecord2 = NodeRecordCheckTest.inUse(NodeRecordCheckTest.array(new DynamicRecord(2L)));
        List<DynamicRecord> labelRecords = Arrays.asList(labelsRecord1, labelsRecord2);
        labelIds[12] = 11L;
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)labelIds, (DynamicRecordAllocator)new ReusableRecordsAllocator(52, labelRecords));
        NodeRecordCheckTest.assertDynamicRecordChain(labelsRecord1, labelsRecord2);
        node.setLabelField(DynamicNodeLabels.dynamicPointer(labelRecords), labelRecords);
        this.addNodeDynamicLabels(labelsRecord1);
        this.addNodeDynamicLabels(labelsRecord2);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).labelDuplicate(11L);
    }

    @Test
    void shouldReportOutOfOrderLabels() {
        final NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, -1L, -1L));
        new InlineNodeLabels(node){

            public Collection<DynamicRecord> put(long[] labelIds, NodeStore nodeStore, DynamicRecordAllocator allocator) {
                return 1.putSorted((NodeRecord)node, (long[])labelIds, (NodeStore)nodeStore, (DynamicRecordAllocator)allocator);
            }
        }.put(new long[]{3L, 1L, 2L}, null, null);
        LabelTokenRecord label1 = NodeRecordCheckTest.inUse(new LabelTokenRecord(1L));
        LabelTokenRecord label2 = NodeRecordCheckTest.inUse(new LabelTokenRecord(2L));
        LabelTokenRecord label3 = NodeRecordCheckTest.inUse(new LabelTokenRecord(3L));
        this.add(label1);
        this.add(label2);
        this.add(label3);
        this.add(node);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).labelsOutOfOrder(3L, 1L);
    }

    @Test
    void shouldProperlyReportOutOfOrderLabelsThatAreFarAway() {
        final NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, -1L, -1L));
        new InlineNodeLabels(node){

            public Collection<DynamicRecord> put(long[] labelIds, NodeStore nodeStore, DynamicRecordAllocator allocator) {
                return 2.putSorted((NodeRecord)node, (long[])labelIds, (NodeStore)nodeStore, (DynamicRecordAllocator)allocator);
            }
        }.put(new long[]{1L, 18L, 13L, 14L, 15L, 16L, 12L}, null, null);
        LabelTokenRecord label1 = NodeRecordCheckTest.inUse(new LabelTokenRecord(1L));
        LabelTokenRecord label12 = NodeRecordCheckTest.inUse(new LabelTokenRecord(12L));
        LabelTokenRecord label13 = NodeRecordCheckTest.inUse(new LabelTokenRecord(13L));
        LabelTokenRecord label14 = NodeRecordCheckTest.inUse(new LabelTokenRecord(14L));
        LabelTokenRecord label15 = NodeRecordCheckTest.inUse(new LabelTokenRecord(15L));
        LabelTokenRecord label16 = NodeRecordCheckTest.inUse(new LabelTokenRecord(16L));
        LabelTokenRecord label18 = NodeRecordCheckTest.inUse(new LabelTokenRecord(18L));
        this.add(label1);
        this.add(label12);
        this.add(label13);
        this.add(label14);
        this.add(label15);
        this.add(label16);
        this.add(label18);
        this.add(node);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).labelsOutOfOrder(18L, 13L);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).labelsOutOfOrder(16L, 12L);
    }

    @Test
    void shouldReportOutOfOrderDynamicLabels() {
        long[] labelIds = this.createLabels(100);
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, -1L, -1L));
        this.add(node);
        DynamicRecord labelsRecord1 = NodeRecordCheckTest.inUse(NodeRecordCheckTest.array(new DynamicRecord(1L)));
        DynamicRecord labelsRecord2 = NodeRecordCheckTest.inUse(NodeRecordCheckTest.array(new DynamicRecord(2L)));
        List<DynamicRecord> labelRecords = Arrays.asList(labelsRecord1, labelsRecord2);
        long temp = labelIds[12];
        labelIds[12] = labelIds[11];
        labelIds[11] = temp;
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)labelIds, (DynamicRecordAllocator)new ReusableRecordsAllocator(52, labelRecords));
        NodeRecordCheckTest.assertDynamicRecordChain(labelsRecord1, labelsRecord2);
        node.setLabelField(DynamicNodeLabels.dynamicPointer(labelRecords), labelRecords);
        this.addNodeDynamicLabels(labelsRecord1);
        this.addNodeDynamicLabels(labelsRecord2);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).labelsOutOfOrder(labelIds[11], labelIds[12]);
    }

    @Test
    void shouldDynamicLabelRecordsNotInUse() {
        long[] labelIds = this.createLabels(100);
        NodeRecord node = NodeRecordCheckTest.inUse(new NodeRecord(42L, false, -1L, -1L));
        this.add(node);
        DynamicRecord labelsRecord1 = NodeRecordCheckTest.notInUse(NodeRecordCheckTest.array(new DynamicRecord(1L)));
        DynamicRecord labelsRecord2 = NodeRecordCheckTest.notInUse(NodeRecordCheckTest.array(new DynamicRecord(2L)));
        List<DynamicRecord> labelRecords = Arrays.asList(labelsRecord1, labelsRecord2);
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)labelIds, (DynamicRecordAllocator)new NotUsedReusableRecordsAllocator(52, labelRecords));
        NodeRecordCheckTest.assertDynamicRecordChain(labelsRecord1, labelsRecord2);
        node.setLabelField(DynamicNodeLabels.dynamicPointer(labelRecords), labelRecords);
        this.addNodeDynamicLabels(labelsRecord1);
        this.addNodeDynamicLabels(labelsRecord2);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)this.check(node);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).dynamicLabelRecordNotInUse(labelsRecord1);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).dynamicLabelRecordNotInUse(labelsRecord2);
    }

    private long[] createLabels(int labelCount) {
        long[] labelIds = new long[labelCount];
        for (int i = 0; i < labelIds.length; ++i) {
            labelIds[i] = i;
            this.add(NodeRecordCheckTest.inUse(new LabelTokenRecord((long)i)));
        }
        return labelIds;
    }

    private static void assertDynamicRecordChain(DynamicRecord ... records) {
        if (records.length > 0) {
            for (int i = 1; i < records.length; ++i) {
                Assertions.assertEquals((long)records[i].getId(), (long)records[i - 1].getNextBlock());
            }
            Assertions.assertTrue((boolean)Record.NO_NEXT_BLOCK.is(records[records.length - 1].getNextBlock()));
        }
    }

    private class NotUsedReusableRecordsAllocator
    extends ReusableRecordsAllocator {
        NotUsedReusableRecordsAllocator(int recordSize, Collection<DynamicRecord> records) {
            super(recordSize, records);
        }

        public DynamicRecord nextRecord() {
            DynamicRecord record = super.nextRecord();
            record.setInUse(false);
            return record;
        }
    }
}

