/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.PropertyRecordCheck;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.TemporalType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class PropertyRecordCheckTest
extends RecordCheckTestBase<PropertyRecord, ConsistencyReport.PropertyConsistencyReport, PropertyRecordCheck> {
    PropertyRecordCheckTest() {
        super(new PropertyRecordCheck(), ConsistencyReport.PropertyConsistencyReport.class, new int[0], new MultiPassStore[0]);
    }

    @Test
    void shouldNotReportAnythingForPropertyRecordNotInUse() {
        PropertyRecord property = PropertyRecordCheckTest.notInUse(new PropertyRecord(42L));
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldNotReportAnythingForPropertyWithoutBlocksThatDoesNotReferenceAnyOtherRecords() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportPropertyKeyNotInUse() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyKeyTokenRecord key = this.add(PropertyRecordCheckTest.notInUse(new PropertyKeyTokenRecord(0)));
        PropertyBlock block = PropertyRecordCheckTest.propertyBlock(key, PropertyType.INT, 0L);
        property.addPropertyBlock(block);
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).keyNotInUse(block, key);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportPreviousPropertyNotInUse() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyRecord prev = this.add(PropertyRecordCheckTest.notInUse(new PropertyRecord(51L)));
        property.setPrevProp(prev.getId());
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).prevNotInUse(prev);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportNextPropertyNotInUse() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyRecord next = this.add(PropertyRecordCheckTest.notInUse(new PropertyRecord(51L)));
        property.setNextProp(next.getId());
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).nextNotInUse(next);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportPreviousPropertyNotReferringBack() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyRecord prev = this.add(PropertyRecordCheckTest.inUse(new PropertyRecord(51L)));
        property.setPrevProp(prev.getId());
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).previousDoesNotReferenceBack(prev);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportNextPropertyNotReferringBack() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyRecord next = this.add(PropertyRecordCheckTest.inUse(new PropertyRecord(51L)));
        property.setNextProp(next.getId());
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).nextDoesNotReferenceBack(next);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportStringRecordNotInUse() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyKeyTokenRecord key = this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        DynamicRecord value = this.add(PropertyRecordCheckTest.notInUse(PropertyRecordCheckTest.string(new DynamicRecord(1001L))));
        PropertyBlock block = PropertyRecordCheckTest.propertyBlock(key, value);
        property.addPropertyBlock(block);
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).stringNotInUse(block, value);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportArrayRecordNotInUse() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyKeyTokenRecord key = this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        DynamicRecord value = this.add(PropertyRecordCheckTest.notInUse(PropertyRecordCheckTest.array(new DynamicRecord(1001L))));
        PropertyBlock block = PropertyRecordCheckTest.propertyBlock(key, value);
        property.addPropertyBlock(block);
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).arrayNotInUse(block, value);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportEmptyStringRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyKeyTokenRecord key = this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        DynamicRecord value = this.add(PropertyRecordCheckTest.inUse(PropertyRecordCheckTest.string(new DynamicRecord(1001L))));
        PropertyBlock block = PropertyRecordCheckTest.propertyBlock(key, value);
        property.addPropertyBlock(block);
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).stringEmpty(block, value);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportUnknownGTypeGeometryRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = GeometryType.encodePoint((int)6, (CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 2.0});
        long gtypeBits = 0xF0000000L;
        longs[0] = longs[0] | gtypeBits;
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReport15DimensionalPointRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = GeometryType.encodePoint((int)6, (CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 2.0});
        long dimensionBits = 0xF00000000L;
        longs[0] = longs[0] | dimensionBits;
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReportUnknownCRSPointRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = GeometryType.encodePoint((int)6, (CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 2.0});
        long crsTableIdAndCodeBits = 0xFFFF000000000L;
        longs[0] = longs[0] | crsTableIdAndCodeBits;
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReportTooHighDateRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = TemporalType.encodeDate((int)6, (long)(LocalDate.MAX.toEpochDay() + 1L));
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReportTooHighLocalTimeRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = TemporalType.encodeLocalTime((int)6, (long)(LocalTime.MAX.toNanoOfDay() + 1L));
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReportTooHighNanoLocalDateTimeRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = TemporalType.encodeLocalDateTime((int)6, (long)1L, (long)1000000000L);
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReportTooHighEpochSecondLocalDateTimeRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = TemporalType.encodeLocalDateTime((int)6, (long)(Instant.MAX.getEpochSecond() + 1L), (long)1L);
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReportTooHighNanoDateTimeRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = TemporalType.encodeDateTime((int)6, (long)1L, (long)1000000000L, (int)0);
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReportTooHighEpochSecondDateTimeRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = TemporalType.encodeDateTime((int)6, (long)(Instant.MAX.getEpochSecond() + 1L), (long)1L, (int)0);
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReportTooHighNanoDateTimeRecordWithNamedTZ() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = TemporalType.encodeDateTime((int)6, (long)1L, (long)1000000000L, (String)"Europe/London");
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReportTooHighEpochSecondDateTimeRecordWithNamedTZ() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = TemporalType.encodeDateTime((int)6, (long)(Instant.MAX.getEpochSecond() + 1L), (long)1L, (String)"Europe/London");
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReportTooHighOffsetSecondDateTimeRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = TemporalType.encodeDateTime((int)6, (long)1L, (long)1L, (int)(ZoneOffset.MAX.getTotalSeconds() + 1));
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReportTooHighNanoTimeRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = TemporalType.encodeTime((int)6, (long)(LocalTime.MAX.toNanoOfDay() + 1L), (int)0);
        this.expectInvalidPropertyValue(property, longs);
    }

    @Test
    void shouldReportTooHighOffsetSecondTimeRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        int keyId = 6;
        this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        long[] longs = TemporalType.encodeTime((int)6, (long)1L, (int)(ZoneOffset.MAX.getTotalSeconds() + 1));
        this.expectInvalidPropertyValue(property, longs);
    }

    private void expectInvalidPropertyValue(PropertyRecord property, long[] longs) {
        PropertyBlock block = new PropertyBlock();
        block.setValueBlocks(longs);
        property.addPropertyBlock(block);
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).invalidPropertyValue(block);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportEmptyArrayRecord() {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyKeyTokenRecord key = this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        DynamicRecord value = this.add(PropertyRecordCheckTest.inUse(PropertyRecordCheckTest.array(new DynamicRecord(1001L))));
        PropertyBlock block = PropertyRecordCheckTest.propertyBlock(key, value);
        property.addPropertyBlock(block);
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).arrayEmpty(block, value);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }
}

