/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public class SchemaRuleUtil {
    private SchemaRuleUtil() {
    }

    public static ConstraintRule uniquenessConstraintRule(long ruleId, int labelId, int propertyId, long indexId) {
        return ConstraintRule.constraintRule((long)ruleId, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propertyId}), (long)indexId);
    }

    public static ConstraintRule nodePropertyExistenceConstraintRule(long ruleId, int labelId, int propertyId) {
        return ConstraintRule.constraintRule((long)ruleId, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)labelId, (int[])new int[]{propertyId}));
    }

    public static ConstraintRule relPropertyExistenceConstraintRule(long ruleId, int labelId, int propertyId) {
        return ConstraintRule.constraintRule((long)ruleId, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)labelId, (int[])new int[]{propertyId}));
    }

    public static StoreIndexDescriptor indexRule(long ruleId, int labelId, int propertyId, IndexProviderDescriptor descriptor) {
        return IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyId}), (IndexProviderDescriptor)descriptor).withId(ruleId);
    }

    public static StoreIndexDescriptor constraintIndexRule(long ruleId, int labelId, int propertyId, IndexProviderDescriptor descriptor, long constraintId) {
        return IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyId}), (IndexProviderDescriptor)descriptor).withIds(ruleId, constraintId);
    }

    public static StoreIndexDescriptor constraintIndexRule(long ruleId, int labelId, int propertyId, IndexProviderDescriptor descriptor) {
        return IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyId}), (IndexProviderDescriptor)descriptor).withId(ruleId);
    }
}

