/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.DefaultCacheAccess;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.statistics.DefaultCounts;

class DefaultClientTest {
    private static ExecutorService executor;

    DefaultClientTest() {
    }

    @BeforeAll
    static void setUp() {
        executor = Executors.newSingleThreadExecutor();
    }

    @AfterAll
    static void tearDown() {
        executor.shutdown();
    }

    @Test
    void checkClientsIdBounds() throws ExecutionException, InterruptedException {
        int threads = 2;
        DefaultCounts counts = new DefaultCounts(threads);
        DefaultCacheAccess cacheAccess = new DefaultCacheAccess((Counts)counts, threads);
        cacheAccess.prepareForProcessingOfSingleStore(34L);
        CacheAccess.Client client1 = cacheAccess.client();
        Assertions.assertTrue((boolean)client1.withinBounds(0L));
        Assertions.assertTrue((boolean)client1.withinBounds(10L));
        Assertions.assertTrue((boolean)client1.withinBounds(33L));
        Assertions.assertFalse((boolean)client1.withinBounds(34L));
        Future<?> secondClientIdChecks = executor.submit(() -> {
            CacheAccess.Client client = cacheAccess.client();
            Assertions.assertFalse((boolean)client.withinBounds(5L));
            Assertions.assertFalse((boolean)client.withinBounds(33L));
            Assertions.assertTrue((boolean)client.withinBounds(34L));
            Assertions.assertTrue((boolean)client.withinBounds(67L));
            Assertions.assertFalse((boolean)client.withinBounds(68L));
        });
        secondClientIdChecks.get();
    }
}

