/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.checking.cache.PackedMultiFieldCache;

class PackedMultiFieldCacheTest {
    PackedMultiFieldCacheTest() {
    }

    @Test
    void shouldPutValuesIntoSlots() {
        PackedMultiFieldCache cache = new PackedMultiFieldCache(new int[]{8, 16, 24, 32, 1});
        int index = 10;
        long[] values = new long[]{3L, 100L, 12345L, 67890L, 0L};
        cache.put((long)index, values);
        for (int i = 0; i < values.length; ++i) {
            Assertions.assertEquals((long)values[i], (long)cache.get((long)index, i));
        }
    }

    @Test
    void shouldHaveCorrectDefaultValues() {
        PackedMultiFieldCache cache = new PackedMultiFieldCache(new int[]{40, 5, 1});
        int index = 0;
        cache.clear((long)index);
        Assertions.assertEquals((long)-1L, (long)cache.get((long)index, 0));
        Assertions.assertEquals((long)0L, (long)cache.get((long)index, 1));
        Assertions.assertEquals((long)0L, (long)cache.get((long)index, 2));
    }

    @Test
    void shouldBeAbleToChangeSlotSize() {
        PackedMultiFieldCache cache = new PackedMultiFieldCache(new int[]{5, 1});
        int index = 10;
        Assertions.assertThrows(IllegalArgumentException.class, () -> cache.put((long)index, 2, 0L));
        cache.setSlotSizes(new int[]{8, 8, 10});
        cache.put((long)index, 2, 10L);
        Assertions.assertEquals((long)10L, (long)cache.get((long)index, 2));
    }

    @Test
    void shouldHandleTwoIdsAndFourBooleans() {
        PackedMultiFieldCache cache = new PackedMultiFieldCache(new int[]{40, 40, 1, 1, 1, 1});
        int index = 3;
        long v1 = 0xFFFFFFFFF6L;
        long v2 = 0xFFFFFFFF9CL;
        cache.put((long)index, new long[]{v1, v2, 0L, 1L, 0L, 1L});
        Assertions.assertEquals((long)v1, (long)cache.get((long)index, 0));
        Assertions.assertEquals((long)v2, (long)cache.get((long)index, 1));
        Assertions.assertEquals((long)0L, (long)cache.get((long)index, 2));
        Assertions.assertEquals((long)-1L, (long)cache.get((long)index, 3));
        Assertions.assertEquals((long)0L, (long)cache.get((long)index, 4));
        Assertions.assertEquals((long)-1L, (long)cache.get((long)index, 5));
    }
}

