/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.full.NodeInUseWithCorrectLabelsCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordAccessStub;
import org.neo4j.consistency.store.synthetic.LabelScanDocument;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.LabelIdArray;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsAllocator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;

class NodeInUseWithCorrectLabelsCheckTest {
    NodeInUseWithCorrectLabelsCheckTest() {
    }

    @Test
    void shouldReportNodeNotInUse() {
        int nodeId = 42;
        long labelId = 7L;
        ConsistencyReport.LabelScanConsistencyReport report = (ConsistencyReport.LabelScanConsistencyReport)Mockito.mock(ConsistencyReport.LabelScanConsistencyReport.class);
        NodeRecord node = RecordCheckTestBase.notInUse(new NodeRecord((long)nodeId, false, 0L, 0L));
        NodeInUseWithCorrectLabelsCheckTest.checker(new long[]{labelId}, true).checkReference(null, node, (CheckerEngine)NodeInUseWithCorrectLabelsCheckTest.engineFor(report), null);
        ((ConsistencyReport.LabelScanConsistencyReport)Mockito.verify((Object)report)).nodeNotInUse(node);
    }

    @Test
    void shouldReportNodeWithoutExpectedLabelWhenLabelsAreInlineBothDirections() {
        int nodeId = 42;
        long[] storeLabelIds = new long[]{7L, 9L};
        long[] indexLabelIds = new long[]{9L, 10L};
        NodeRecord node = RecordCheckTestBase.inUse(NodeInUseWithCorrectLabelsCheckTest.withInlineLabels(new NodeRecord((long)nodeId, false, 0L, 0L), storeLabelIds));
        ConsistencyReport.LabelScanConsistencyReport report = (ConsistencyReport.LabelScanConsistencyReport)Mockito.mock(ConsistencyReport.LabelScanConsistencyReport.class);
        NodeInUseWithCorrectLabelsCheckTest.checker(indexLabelIds, true).checkReference(null, node, (CheckerEngine)NodeInUseWithCorrectLabelsCheckTest.engineFor(report), null);
        ((ConsistencyReport.LabelScanConsistencyReport)Mockito.verify((Object)report)).nodeDoesNotHaveExpectedLabel(node, 10L);
    }

    @Test
    void shouldReportNodeWithoutExpectedLabelWhenLabelsAreInlineIndexToStore() {
        int nodeId = 42;
        long[] storeLabelIds = new long[]{7L, 9L};
        long[] indexLabelIds = new long[]{9L, 10L};
        NodeRecord node = RecordCheckTestBase.inUse(NodeInUseWithCorrectLabelsCheckTest.withInlineLabels(new NodeRecord((long)nodeId, false, 0L, 0L), storeLabelIds));
        ConsistencyReport.LabelScanConsistencyReport report = (ConsistencyReport.LabelScanConsistencyReport)Mockito.mock(ConsistencyReport.LabelScanConsistencyReport.class);
        NodeInUseWithCorrectLabelsCheckTest.checker(indexLabelIds, false).checkReference(null, node, (CheckerEngine)NodeInUseWithCorrectLabelsCheckTest.engineFor(report), null);
        ((ConsistencyReport.LabelScanConsistencyReport)Mockito.verify((Object)report)).nodeDoesNotHaveExpectedLabel(node, 10L);
    }

    @Test
    void shouldReportNodeWithoutExpectedLabelWhenLabelsAreDynamicBothDirections() {
        int nodeId = 42;
        long[] indexLabelIds = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L};
        long[] storeLabelIds = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 8L, 9L, 10L, 11L};
        RecordAccessStub recordAccess = new RecordAccessStub();
        NodeRecord node = RecordCheckTestBase.inUse(NodeInUseWithCorrectLabelsCheckTest.withDynamicLabels(recordAccess, new NodeRecord((long)nodeId, false, 0L, 0L), storeLabelIds));
        ConsistencyReport.LabelScanConsistencyReport report = (ConsistencyReport.LabelScanConsistencyReport)Mockito.mock(ConsistencyReport.LabelScanConsistencyReport.class);
        CheckerEngine<Object, ConsistencyReport.LabelScanConsistencyReport> engine = recordAccess.engine(null, report);
        NodeInUseWithCorrectLabelsCheckTest.checker(indexLabelIds, true).checkReference(null, node, engine, (RecordAccess)recordAccess);
        recordAccess.checkDeferred();
        ((ConsistencyReport.LabelScanConsistencyReport)Mockito.verify((Object)report)).nodeDoesNotHaveExpectedLabel(node, 7L);
        ((ConsistencyReport.LabelScanConsistencyReport)Mockito.verify((Object)report)).nodeLabelNotInIndex(node, 11L);
    }

    @Test
    void shouldReportNodeWithoutExpectedLabelWhenLabelsAreDynamicIndexToStore() {
        int nodeId = 42;
        long[] indexLabelIds = new long[]{3L, 7L, 9L, 10L};
        long[] storeLabelIds = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 8L, 9L, 10L};
        long missingLabelId = 7L;
        RecordAccessStub recordAccess = new RecordAccessStub();
        NodeRecord node = RecordCheckTestBase.inUse(NodeInUseWithCorrectLabelsCheckTest.withDynamicLabels(recordAccess, new NodeRecord((long)nodeId, false, 0L, 0L), storeLabelIds));
        ConsistencyReport.LabelScanConsistencyReport report = (ConsistencyReport.LabelScanConsistencyReport)Mockito.mock(ConsistencyReport.LabelScanConsistencyReport.class);
        CheckerEngine<Object, ConsistencyReport.LabelScanConsistencyReport> engine = recordAccess.engine(null, report);
        NodeInUseWithCorrectLabelsCheckTest.checker(indexLabelIds, true).checkReference(null, node, engine, (RecordAccess)recordAccess);
        recordAccess.checkDeferred();
        ((ConsistencyReport.LabelScanConsistencyReport)Mockito.verify((Object)report)).nodeDoesNotHaveExpectedLabel(node, missingLabelId);
    }

    @Test
    void reportNodeWithoutLabelsWhenLabelsAreInlined() {
        int nodeId = 42;
        long[] indexLabelIds = new long[]{3L};
        long[] storeLabelIds = new long[]{};
        long missingLabelId = 3L;
        RecordAccessStub recordAccess = new RecordAccessStub();
        NodeRecord node = RecordCheckTestBase.inUse(NodeInUseWithCorrectLabelsCheckTest.withInlineLabels(new NodeRecord((long)nodeId, false, 0L, 0L), storeLabelIds));
        ConsistencyReport.LabelScanConsistencyReport report = (ConsistencyReport.LabelScanConsistencyReport)Mockito.mock(ConsistencyReport.LabelScanConsistencyReport.class);
        CheckerEngine<Object, ConsistencyReport.LabelScanConsistencyReport> engine = recordAccess.engine(null, report);
        NodeInUseWithCorrectLabelsCheckTest.checker(indexLabelIds, true).checkReference(null, node, engine, (RecordAccess)recordAccess);
        recordAccess.checkDeferred();
        ((ConsistencyReport.LabelScanConsistencyReport)Mockito.verify((Object)report)).nodeDoesNotHaveExpectedLabel(node, missingLabelId);
    }

    @Test
    void reportNodeWithoutLabelsWhenLabelsAreDynamic() {
        int nodeId = 42;
        long[] indexLabelIds = new long[]{3L, 7L, 9L, 10L};
        long[] storeLabelIds = new long[]{};
        long[] missingLabelIds = new long[]{3L, 7L, 9L, 10L};
        RecordAccessStub recordAccess = new RecordAccessStub();
        NodeRecord node = RecordCheckTestBase.inUse(NodeInUseWithCorrectLabelsCheckTest.withDynamicLabels(recordAccess, new NodeRecord((long)nodeId, false, 0L, 0L), storeLabelIds));
        ConsistencyReport.LabelScanConsistencyReport report = (ConsistencyReport.LabelScanConsistencyReport)Mockito.mock(ConsistencyReport.LabelScanConsistencyReport.class);
        CheckerEngine<Object, ConsistencyReport.LabelScanConsistencyReport> engine = recordAccess.engine(null, report);
        NodeInUseWithCorrectLabelsCheckTest.checker(indexLabelIds, true).checkReference(null, node, engine, (RecordAccess)recordAccess);
        recordAccess.checkDeferred();
        for (long missingLabelId : missingLabelIds) {
            ((ConsistencyReport.LabelScanConsistencyReport)Mockito.verify((Object)report)).nodeDoesNotHaveExpectedLabel(node, missingLabelId);
        }
    }

    @Test
    void shouldRemainSilentWhenEverythingIsInOrder() {
        int nodeId = 42;
        int labelId = 7;
        NodeRecord node = NodeInUseWithCorrectLabelsCheckTest.withInlineLabels(RecordCheckTestBase.inUse(new NodeRecord((long)nodeId, false, 0L, 0L)), labelId);
        ConsistencyReport.LabelScanConsistencyReport report = (ConsistencyReport.LabelScanConsistencyReport)Mockito.mock(ConsistencyReport.LabelScanConsistencyReport.class);
        NodeInUseWithCorrectLabelsCheckTest.checker(new long[]{labelId}, true).checkReference(null, node, (CheckerEngine)NodeInUseWithCorrectLabelsCheckTest.engineFor(report), null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    private static NodeRecord withInlineLabels(NodeRecord nodeRecord, long ... labelIds) {
        new InlineNodeLabels(nodeRecord).put(labelIds, null, null);
        return nodeRecord;
    }

    private static NodeRecord withDynamicLabels(RecordAccessStub recordAccess, NodeRecord nodeRecord, long ... labelIds) {
        ArrayList<DynamicRecord> preAllocatedRecords = new ArrayList<DynamicRecord>();
        for (int i = 0; i < 10; ++i) {
            preAllocatedRecords.add(RecordCheckTestBase.inUse(new DynamicRecord((long)i)));
        }
        ArrayList dynamicRecords = new ArrayList();
        DynamicArrayStore.allocateFromNumbers(dynamicRecords, (Object)LabelIdArray.prependNodeId((long)nodeRecord.getId(), (long[])labelIds), (DynamicRecordAllocator)new ReusableRecordsAllocator(4, preAllocatedRecords));
        for (DynamicRecord dynamicRecord : dynamicRecords) {
            recordAccess.addNodeDynamicLabels(dynamicRecord);
        }
        nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer(dynamicRecords), dynamicRecords);
        return nodeRecord;
    }

    private static Engine engineFor(ConsistencyReport.LabelScanConsistencyReport report) {
        Engine engine = (Engine)Mockito.mock(Engine.class);
        Mockito.when((Object)engine.report()).thenReturn((Object)report);
        return engine;
    }

    private static NodeInUseWithCorrectLabelsCheck<LabelScanDocument, ConsistencyReport.LabelScanConsistencyReport> checker(long[] expectedLabels, boolean checkStoreToIndex) {
        return new NodeInUseWithCorrectLabelsCheck(expectedLabels, SchemaDescriptor.PropertySchemaType.COMPLETE_ALL_TOKENS, checkStoreToIndex);
    }

    static interface Engine
    extends CheckerEngine<LabelScanDocument, ConsistencyReport.LabelScanConsistencyReport> {
    }
}

