/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.function.Predicate;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.test.rule.NeoStoresRule;

public class StoreProcessorTest {
    @Rule
    public final NeoStoresRule stores = new NeoStoresRule(this.getClass(), new StoreType[]{StoreType.NODE, StoreType.NODE_LABEL});

    @Test
    public void shouldProcessAllTheRecordsInAStore() throws Exception {
        NodeStore nodeStore = this.stores.builder().build().getNodeStore();
        ConsistencyReport.Reporter reporter = (ConsistencyReport.Reporter)Mockito.mock(ConsistencyReport.Reporter.class);
        StoreProcessor processor = new StoreProcessor(CheckDecorator.NONE, reporter, Stage.SEQUENTIAL_FORWARD, CacheAccess.EMPTY);
        nodeStore.updateRecord((AbstractBaseRecord)this.node(0L, false, 0L, 0L));
        nodeStore.updateRecord((AbstractBaseRecord)this.node(1L, false, 0L, 0L));
        nodeStore.updateRecord((AbstractBaseRecord)this.node(2L, false, 0L, 0L));
        nodeStore.setHighestPossibleIdInUse(2L);
        processor.applyFiltered((RecordStore)nodeStore, new Predicate[0]);
        ((ConsistencyReport.Reporter)Mockito.verify((Object)reporter, (VerificationMode)Mockito.times((int)3))).forNode((NodeRecord)ArgumentMatchers.any(NodeRecord.class), (RecordCheck)ArgumentMatchers.any(RecordCheck.class));
    }

    private NodeRecord node(long id, boolean dense, long nextRel, long nextProp) {
        return new NodeRecord(id).initialize(true, nextProp, dense, nextRel, 0L);
    }

    @Test
    public void shouldStopProcessingRecordsWhenSignalledToStop() throws Exception {
        ConsistencyReport.Reporter reporter = (ConsistencyReport.Reporter)Mockito.mock(ConsistencyReport.Reporter.class);
        final StoreProcessor processor = new StoreProcessor(CheckDecorator.NONE, reporter, Stage.SEQUENTIAL_FORWARD, CacheAccess.EMPTY);
        RecordStore.Delegator<NodeRecord> nodeStore = new RecordStore.Delegator<NodeRecord>((RecordStore)this.stores.builder().build().getNodeStore()){

            public void getRecordByCursor(long id, NodeRecord target, RecordLoad mode, PageCursor cursor) throws InvalidRecordException {
                if (id == 3L) {
                    processor.stop();
                }
                super.getRecordByCursor(id, (AbstractBaseRecord)target, mode, cursor);
            }
        };
        nodeStore.updateRecord((AbstractBaseRecord)this.node(0L, false, 0L, 0L));
        nodeStore.updateRecord((AbstractBaseRecord)this.node(1L, false, 0L, 0L));
        nodeStore.updateRecord((AbstractBaseRecord)this.node(2L, false, 0L, 0L));
        nodeStore.updateRecord((AbstractBaseRecord)this.node(3L, false, 0L, 0L));
        nodeStore.updateRecord((AbstractBaseRecord)this.node(4L, false, 0L, 0L));
        nodeStore.setHighestPossibleIdInUse(4L);
        processor.applyFiltered((RecordStore)nodeStore, new Predicate[0]);
        ((ConsistencyReport.Reporter)Mockito.verify((Object)reporter, (VerificationMode)Mockito.times((int)3))).forNode((NodeRecord)ArgumentMatchers.any(NodeRecord.class), (RecordCheck)ArgumentMatchers.any(RecordCheck.class));
    }
}

