/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.report.PendingReferenceCheck;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;

class PendingReferenceCheckTest {
    private PendingReferenceCheck<PropertyRecord> referenceCheck;

    PendingReferenceCheckTest() {
    }

    @BeforeEach
    void setUp() {
        RecordAccess records = (RecordAccess)Mockito.mock(RecordAccess.class);
        ConsistencyReporter.ReportHandler handler = new ConsistencyReporter.ReportHandler((InconsistencyReport)Mockito.mock(InconsistencyReport.class), (ConsistencyReporter.ProxyFactory)Mockito.mock(ConsistencyReporter.ProxyFactory.class), RecordType.PROPERTY, records, (AbstractBaseRecord)new PropertyRecord(0L), ConsistencyReporter.NO_MONITOR);
        this.referenceCheck = new PendingReferenceCheck((CheckerEngine)handler, (ComparativeRecordChecker)Mockito.mock(ComparativeRecordChecker.class));
    }

    @Test
    void shouldAllowSkipAfterSkip() {
        this.referenceCheck.skip();
        this.referenceCheck.skip();
    }

    @Test
    void shouldAllowSkipAfterCheckReference() {
        this.referenceCheck.checkReference((AbstractBaseRecord)new PropertyRecord(0L), null);
        this.referenceCheck.skip();
    }

    @Test
    void shouldAllowSkipAfterCheckDiffReference() {
        this.referenceCheck.checkDiffReference((AbstractBaseRecord)new PropertyRecord(0L), (AbstractBaseRecord)new PropertyRecord(0L), null);
        this.referenceCheck.skip();
    }

    @Test
    void shouldNotAllowCheckReferenceAfterSkip() {
        this.referenceCheck.skip();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.referenceCheck.checkReference((AbstractBaseRecord)new PropertyRecord(0L), null));
        Assertions.assertEquals((Object)"Reference has already been checked.", (Object)exception.getMessage());
    }

    @Test
    void shouldNotAllowCheckDiffReferenceAfterSkip() {
        this.referenceCheck.skip();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.referenceCheck.checkDiffReference((AbstractBaseRecord)new PropertyRecord(0L), (AbstractBaseRecord)new PropertyRecord(0L), null));
        Assertions.assertEquals((Object)"Reference has already been checked.", (Object)exception.getMessage());
    }

    @Test
    void shouldNotAllowCheckReferenceAfterCheckReference() {
        this.referenceCheck.checkReference((AbstractBaseRecord)new PropertyRecord(0L), null);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.referenceCheck.checkReference((AbstractBaseRecord)new PropertyRecord(0L), null));
        Assertions.assertEquals((Object)"Reference has already been checked.", (Object)exception.getMessage());
    }

    @Test
    void shouldNotAllowCheckDiffReferenceAfterCheckReference() {
        this.referenceCheck.checkReference((AbstractBaseRecord)new PropertyRecord(0L), null);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.referenceCheck.checkDiffReference((AbstractBaseRecord)new PropertyRecord(0L), (AbstractBaseRecord)new PropertyRecord(0L), null));
        Assertions.assertEquals((Object)"Reference has already been checked.", (Object)exception.getMessage());
    }

    @Test
    void shouldNotAllowCheckReferenceAfterCheckDiffReference() {
        this.referenceCheck.checkDiffReference((AbstractBaseRecord)new PropertyRecord(0L), (AbstractBaseRecord)new PropertyRecord(0L), null);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.referenceCheck.checkReference((AbstractBaseRecord)new PropertyRecord(0L), null));
        Assertions.assertEquals((Object)"Reference has already been checked.", (Object)exception.getMessage());
    }

    @Test
    void shouldNotAllowCheckDiffReferenceAfterCheckDiffReference() {
        this.referenceCheck.checkDiffReference((AbstractBaseRecord)new PropertyRecord(0L), (AbstractBaseRecord)new PropertyRecord(0L), null);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.referenceCheck.checkDiffReference((AbstractBaseRecord)new PropertyRecord(0L), (AbstractBaseRecord)new PropertyRecord(0L), null));
        Assertions.assertEquals((Object)"Reference has already been checked.", (Object)exception.getMessage());
    }
}

