/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.time.ZoneId;
import java.util.List;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Strings;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfigurableStandalonePageCacheFactory;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredChecker;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredException;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.scheduler.JobScheduler;

public class ConsistencyCheckTool {
    private static final String CONFIG = "config";
    private static final String VERBOSE = "v";
    private final ConsistencyCheckService consistencyCheckService;
    private final PrintStream systemOut;
    private final PrintStream systemError;
    private final FileSystemAbstraction fs;

    public static void main(String[] args) {
        try {
            System.err.println("WARNING: ConsistencyCheckTool is deprecated and support for it will beremoved in a future version of Neo4j. Please use neo4j-admin check-consistency.");
            ConsistencyCheckTool.runConsistencyCheckTool(args, System.out, System.err);
        }
        catch (ToolFailureException e) {
            e.exitTool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConsistencyCheckService.Result runConsistencyCheckTool(String[] args, PrintStream outStream, PrintStream errStream) throws ToolFailureException {
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        try {
            ConsistencyCheckTool tool = new ConsistencyCheckTool(new ConsistencyCheckService(), (FileSystemAbstraction)fileSystem, outStream, errStream);
            ConsistencyCheckService.Result result = tool.run(args);
            return result;
        }
        finally {
            try {
                fileSystem.close();
            }
            catch (IOException e) {
                System.err.print("Failure during file system shutdown.");
            }
        }
    }

    ConsistencyCheckTool(ConsistencyCheckService consistencyCheckService, FileSystemAbstraction fs, PrintStream systemOut, PrintStream systemError) {
        this.consistencyCheckService = consistencyCheckService;
        this.fs = fs;
        this.systemOut = systemOut;
        this.systemError = systemError;
    }

    ConsistencyCheckService.Result run(String ... args) throws ToolFailureException {
        Args arguments = Args.withFlags((String[])new String[]{VERBOSE}).parse(args);
        File storeDir = this.determineStoreDirectory(arguments);
        Config tuningConfiguration = ConsistencyCheckTool.readConfiguration(arguments);
        boolean verbose = ConsistencyCheckTool.isVerbose(arguments);
        DatabaseLayout databaseLayout = DatabaseLayout.of((File)storeDir);
        this.checkDbState(databaseLayout, tuningConfiguration);
        ZoneId logTimeZone = ((LogTimeZone)tuningConfiguration.get(GraphDatabaseSettings.db_timezone)).getZoneId();
        FormattedLogProvider logProvider = FormattedLogProvider.withZoneId((ZoneId)logTimeZone).toOutputStream((OutputStream)this.systemOut);
        try {
            return this.consistencyCheckService.runFullConsistencyCheck(databaseLayout, tuningConfiguration, ProgressMonitorFactory.textual((OutputStream)this.systemError), (LogProvider)logProvider, this.fs, verbose, new ConsistencyFlags(tuningConfiguration));
        }
        catch (ConsistencyCheckIncompleteException e) {
            throw new ToolFailureException("Check aborted due to exception", e);
        }
    }

    private static boolean isVerbose(Args arguments) {
        return arguments.getBoolean(VERBOSE, Boolean.valueOf(false), Boolean.valueOf(true));
    }

    private void checkDbState(DatabaseLayout databaseLayout, Config tuningConfiguration) throws ToolFailureException {
        try (JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
             PageCache pageCache = ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fs, (Config)tuningConfiguration, (JobScheduler)jobScheduler);){
            RecoveryRequiredChecker.assertRecoveryIsNotRequired((FileSystemAbstraction)this.fs, (PageCache)pageCache, (Config)tuningConfiguration, (DatabaseLayout)databaseLayout, (Monitors)new Monitors());
        }
        catch (RecoveryRequiredException rre) {
            throw new ToolFailureException(rre.getMessage());
        }
        catch (Exception e) {
            this.systemError.printf("Failure when checking for recovery state: '%s', continuing as normal.%n", e);
        }
    }

    private File determineStoreDirectory(Args arguments) throws ToolFailureException {
        List unprefixedArguments = arguments.orphans();
        if (unprefixedArguments.size() != 1) {
            throw new ToolFailureException(this.usage());
        }
        File storeDir = new File((String)unprefixedArguments.get(0));
        if (!storeDir.isDirectory()) {
            throw new ToolFailureException(Strings.joinAsLines((String[])new String[]{String.format("'%s' is not a directory", storeDir)}) + this.usage());
        }
        return storeDir;
    }

    private static Config readConfiguration(Args arguments) throws ToolFailureException {
        String configFilePath = arguments.get(CONFIG, null);
        if (configFilePath != null) {
            File configFile = new File(configFilePath);
            try {
                return Config.fromFile((File)configFile).build();
            }
            catch (Exception e) {
                throw new ToolFailureException(String.format("Could not read configuration file [%s]", configFilePath), e);
            }
        }
        return Config.defaults();
    }

    private String usage() {
        return Strings.joinAsLines((String[])new String[]{Args.jarUsage(this.getClass(), (String[])new String[]{" [-config <neo4j.conf>] [-v] <storedir>"}), "WHERE:   -config <filename>  Is the location of an optional properties file", "                             containing tuning parameters for the consistency check.", "         -v                  Produce execution output.", "         <storedir>          Is the path to the store to check."});
    }

    private static void exit() {
        System.exit(1);
    }

    public static class ToolFailureException
    extends Exception {
        ToolFailureException(String message) {
            super(message);
        }

        ToolFailureException(String message, Throwable cause) {
            super(message, cause);
        }

        public void exitTool() {
            this.printErrorMessage();
            ConsistencyCheckTool.exit();
        }

        public void printErrorMessage() {
            System.err.println(this.getMessage());
            if (this.getCause() != null) {
                this.getCause().printStackTrace(System.err);
            }
        }
    }
}

